/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.KL7Sim;
import gui.Key;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import kl7.Box;
import kl7.BoxMode;

public class K4Panel
extends JFrame {
    static final long serialVersionUID = 106201888L;
    static final String[] rotors = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
    static final String[] indices = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36"};
    static final String[] nrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
    public static final String[] nRingMark = new String[]{"A", "B", "B+", "C", "D", "E", "E+", "F", "G", "G+", "H", "I", "J", "J+", "K", "L", "M", "M+", "N", "O", "O+", "P", "Q", "R", "R+", "S", "T", "T+", "U", "V", "W", "W+", "X", "Y", "Z", "Z+"};
    private ArrayList<JComboBox<String>> rot = null;
    private ArrayList<JComboBox<String>> lring = null;
    private ArrayList<JComboBox<String>> nr = null;
    private ArrayList<JComboBox<String>> nrp = null;
    public boolean oldNrPos = false;
    private Box box = null;
    private KL7Sim ksim = null;
    private JPanel contentPane = null;
    private CListen cl = null;
    JFileChooser fc = null;
    TxtFilter tf = null;
    String[] monthsLong;
    String[] monthsShort;
    String[] checksum;
    String charSysInd = "";
    String numSysInd = "";
    String keyChSysInd = "";
    String keyNumSysInd = "";
    Calendar cal = null;
    DateFormatSymbols dfs = null;

    public K4Panel(Box box, KL7Sim ksim) {
        this();
        this.box = box;
        this.ksim = ksim;
        this.getBox();
    }

    public K4Panel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.contentPane = new JPanel();
        this.setBackground(Color.LIGHT_GRAY);
        this.setBounds(40, 60, 448, 400);
        this.setVisible(false);
        this.getContentPane().setLayout(null);
        this.setContentPane(this.contentPane);
        this.setResizable(false);
        this.setTitle("Rotor Selection and Inner Settings");
        this.cl = new CListen();
        this.addComponentListener(this.cl);
        this.fc = new JFileChooser();
        this.tf = new TxtFilter();
        this.fc.setFileFilter(this.tf);
        this.cal = Calendar.getInstance();
        this.dfs = new DateFormatSymbols();
        this.monthsLong = this.dfs.getMonths();
        this.monthsShort = this.dfs.getShortMonths();
        this.checksum = new String[2];
        this.contentPane.setOpaque(true);
        this.contentPane.setBorder(new BevelBorder(0, Color.BLACK, null, Color.BLACK, Color.LIGHT_GRAY));
        this.contentPane.setLayout(null);
        this.setSize(new Dimension(460, 400));
        this.getContentPane().setLayout(null);
        JLabel lblTitle = new JLabel("KL-7 Key Settings");
        lblTitle.setFont(new Font("Lucida Grande", 1, 16));
        lblTitle.setBounds(14, 6, 166, 24);
        this.getContentPane().add(lblTitle);
        JLabel lblRotor = new JLabel("Rotor");
        lblRotor.setFont(new Font("SansSerif", 2, 12));
        lblRotor.setBounds(82, 42, 61, 16);
        this.getContentPane().add(lblRotor);
        JLabel lblLetter = new JLabel("Alphabet");
        lblLetter.setFont(new Font("SansSerif", 2, 12));
        lblLetter.setBounds(155, 42, 75, 16);
        this.getContentPane().add(lblLetter);
        JLabel lblOffset = new JLabel("Position");
        lblOffset.setFont(new Font("SansSerif", 2, 12));
        lblOffset.setBounds(155, 57, 61, 16);
        this.getContentPane().add(lblOffset);
        JLabel lblSelection = new JLabel("Selection");
        lblSelection.setFont(new Font("SansSerif", 2, 12));
        lblSelection.setBounds(82, 57, 61, 16);
        this.getContentPane().add(lblSelection);
        JLabel lblNotchedRing = new JLabel("Notched Ring");
        lblNotchedRing.setFont(new Font("SansSerif", 2, 12));
        lblNotchedRing.setBounds(260, 42, 90, 16);
        this.getContentPane().add(lblNotchedRing);
        JLabel lblSelection_1 = new JLabel("Selection");
        lblSelection_1.setFont(new Font("SansSerif", 2, 12));
        lblSelection_1.setBounds(260, 57, 61, 16);
        this.getContentPane().add(lblSelection_1);
        JLabel lblNotchedRing_1 = new JLabel("Notched Ring");
        lblNotchedRing_1.setFont(new Font("SansSerif", 2, 12));
        lblNotchedRing_1.setBounds(362, 42, 90, 16);
        this.getContentPane().add(lblNotchedRing_1);
        JLabel lblOffset_1 = new JLabel("Position");
        lblOffset_1.setFont(new Font("SansSerif", 2, 12));
        lblOffset_1.setBounds(362, 57, 48, 16);
        this.getContentPane().add(lblOffset_1);
        JLabel label = new JLabel("1");
        label.setBounds(41, 88, 29, 16);
        this.getContentPane().add(label);
        JLabel label_1 = new JLabel("2");
        label_1.setBounds(41, 116, 29, 16);
        this.getContentPane().add(label_1);
        JLabel label_2 = new JLabel("3");
        label_2.setBounds(41, 144, 29, 16);
        this.getContentPane().add(label_2);
        JLabel label_3 = new JLabel("4");
        label_3.setBounds(41, 172, 29, 16);
        this.getContentPane().add(label_3);
        JLabel label_4 = new JLabel("5");
        label_4.setBounds(41, 200, 29, 16);
        this.getContentPane().add(label_4);
        JLabel label_5 = new JLabel("6");
        label_5.setBounds(41, 228, 29, 16);
        this.getContentPane().add(label_5);
        JLabel label_6 = new JLabel("7");
        label_6.setBounds(41, 256, 29, 15);
        this.getContentPane().add(label_6);
        JLabel label_7 = new JLabel("8");
        label_7.setBounds(41, 287, 29, 15);
        this.getContentPane().add(label_7);
        this.rot = new ArrayList(8);
        this.rot.add(0, new JComboBox());
        this.rot.get(0).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(0).setBounds(82, 84, 47, 25);
        this.getContentPane().add(this.rot.get(0));
        this.rot.add(1, new JComboBox());
        this.rot.get(1).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(1).setBounds(82, 112, 47, 25);
        this.getContentPane().add(this.rot.get(1));
        this.rot.add(2, new JComboBox());
        this.rot.get(2).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(2).setBounds(82, 140, 47, 25);
        this.getContentPane().add(this.rot.get(2));
        this.rot.add(3, new JComboBox());
        this.rot.get(3).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(3).setBounds(82, 168, 47, 25);
        this.getContentPane().add(this.rot.get(3));
        this.rot.add(4, new JComboBox());
        this.rot.get(4).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(4).setBounds(82, 196, 47, 25);
        this.getContentPane().add(this.rot.get(4));
        this.rot.add(5, new JComboBox());
        this.rot.get(5).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(5).setBounds(82, 224, 47, 25);
        this.getContentPane().add(this.rot.get(5));
        this.rot.add(6, new JComboBox());
        this.rot.get(6).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(6).setBounds(82, 251, 47, 25);
        this.getContentPane().add(this.rot.get(6));
        this.rot.add(7, new JComboBox());
        this.rot.get(7).setModel(new DefaultComboBoxModel<String>(rotors));
        this.rot.get(7).setBounds(82, 282, 47, 25);
        this.getContentPane().add(this.rot.get(7));
        this.lring = new ArrayList(8);
        this.lring.add(0, new JComboBox());
        this.lring.get(0).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(0).setBounds(155, 84, 50, 25);
        this.getContentPane().add(this.lring.get(0));
        this.lring.add(1, new JComboBox());
        this.lring.get(1).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(1).setBounds(155, 112, 50, 25);
        this.getContentPane().add(this.lring.get(1));
        this.lring.add(2, new JComboBox());
        this.lring.get(2).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(2).setBounds(155, 140, 50, 25);
        this.getContentPane().add(this.lring.get(2));
        this.lring.add(3, new JComboBox());
        this.lring.get(3).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(3).setBounds(155, 169, 50, 25);
        this.getContentPane().add(this.lring.get(3));
        this.lring.add(4, new JComboBox());
        this.lring.get(4).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(4).setBounds(155, 196, 50, 25);
        this.getContentPane().add(this.lring.get(4));
        this.lring.add(5, new JComboBox());
        this.lring.get(5).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(5).setBounds(155, 224, 50, 25);
        this.getContentPane().add(this.lring.get(5));
        this.lring.add(6, new JComboBox());
        this.lring.get(6).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(6).setBounds(155, 251, 50, 25);
        this.getContentPane().add(this.lring.get(6));
        this.lring.add(7, new JComboBox());
        this.lring.get(7).setModel(new DefaultComboBoxModel<String>(indices));
        this.lring.get(7).setBounds(155, 282, 50, 25);
        this.getContentPane().add(this.lring.get(7));
        this.nr = new ArrayList(7);
        this.nr.add(0, new JComboBox());
        this.nr.get(0).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(0).setBounds(260, 84, 50, 25);
        this.getContentPane().add(this.nr.get(0));
        this.nr.add(1, new JComboBox());
        this.nr.get(1).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(1).setBounds(260, 112, 50, 25);
        this.getContentPane().add(this.nr.get(1));
        this.nr.add(2, new JComboBox());
        this.nr.get(2).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(2).setBounds(260, 140, 50, 25);
        this.getContentPane().add(this.nr.get(2));
        this.nr.add(3, new JComboBox());
        this.nr.get(3).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(3).setBounds(260, 196, 50, 25);
        this.getContentPane().add(this.nr.get(3));
        this.nr.add(4, new JComboBox());
        this.nr.get(4).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(4).setBounds(260, 224, 50, 25);
        this.getContentPane().add(this.nr.get(4));
        this.nr.add(5, new JComboBox());
        this.nr.get(5).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(5).setBounds(260, 251, 50, 25);
        this.getContentPane().add(this.nr.get(5));
        this.nr.add(6, new JComboBox());
        this.nr.get(6).setModel(new DefaultComboBoxModel<String>(nrings));
        this.nr.get(6).setBounds(260, 282, 50, 25);
        this.getContentPane().add(this.nr.get(6));
        this.nrp = new ArrayList(7);
        this.nrp.add(0, new JComboBox());
        this.nrp.get(0).setBounds(362, 84, 55, 25);
        this.getContentPane().add(this.nrp.get(0));
        this.nrp.add(1, new JComboBox());
        this.nrp.get(1).setBounds(362, 112, 55, 25);
        this.getContentPane().add(this.nrp.get(1));
        this.nrp.add(2, new JComboBox());
        this.nrp.get(2).setBounds(362, 140, 55, 25);
        this.getContentPane().add(this.nrp.get(2));
        this.nrp.add(3, new JComboBox());
        this.nrp.get(3).setBounds(362, 196, 55, 25);
        this.getContentPane().add(this.nrp.get(3));
        this.nrp.add(4, new JComboBox());
        this.nrp.get(4).setBounds(362, 224, 55, 25);
        this.getContentPane().add(this.nrp.get(4));
        this.nrp.add(5, new JComboBox());
        this.nrp.get(5).setBounds(362, 251, 55, 25);
        this.getContentPane().add(this.nrp.get(5));
        this.nrp.add(6, new JComboBox());
        this.nrp.get(6).setBounds(362, 282, 55, 25);
        this.getContentPane().add(this.nrp.get(6));
        this.setNrp(true);
        JLabel lblNone = new JLabel("none");
        lblNone.setEnabled(false);
        lblNone.setFont(new Font("SansSerif", 1, 12));
        lblNone.setHorizontalAlignment(0);
        lblNone.setBounds(260, 173, 50, 15);
        this.getContentPane().add(lblNone);
        JLabel lblNone_1 = new JLabel("none");
        lblNone_1.setEnabled(false);
        lblNone_1.setFont(new Font("SansSerif", 1, 12));
        lblNone_1.setHorizontalAlignment(0);
        lblNone_1.setBounds(362, 173, 50, 15);
        this.getContentPane().add(lblNone_1);
        JButton btnDeleteKey = new JButton("Zeroize");
        btnDeleteKey.setFont(new Font("SansSerif", 1, 11));
        btnDeleteKey.setBounds(12, 334, 79, 27);
        btnDeleteKey.setToolTipText("Reset all rotor settings to default.");
        btnDeleteKey.addActionListener(new ButtonHandler(ButtType.DELETE, this));
        this.getContentPane().add(btnDeleteKey);
        JButton btnLoadKey = new JButton("Load key");
        btnLoadKey.setToolTipText("Load saved key setting form file.");
        btnLoadKey.setFont(new Font("SansSerif", 1, 11));
        btnLoadKey.setBounds(95, 333, 85, 29);
        btnLoadKey.addActionListener(new ButtonHandler(ButtType.LOAD, this));
        this.contentPane.add(btnLoadKey);
        JButton btnSetKey = new JButton("Set Key");
        btnSetKey.setFont(new Font("SansSerif", 1, 11));
        btnSetKey.setBounds(184, 334, 79, 27);
        btnSetKey.setToolTipText("Commit this key setting. Avoids storing key on disk - good for security, or experiments.");
        btnSetKey.addActionListener(new ButtonHandler(ButtType.SET, this));
        this.getContentPane().add(btnSetKey);
        JButton btnSaveKey = new JButton("Set & Save");
        btnSaveKey.setFont(new Font("SansSerif", 1, 11));
        btnSaveKey.setBounds(267, 334, 98, 27);
        btnSaveKey.setToolTipText("Commit this key setting and save it to file.");
        btnSaveKey.addActionListener(new ButtonHandler(ButtType.SAVE, this));
        this.getContentPane().add(btnSaveKey);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setFont(new Font("SansSerif", 1, 11));
        btnCancel.setBounds(368, 334, 78, 27);
        btnCancel.setToolTipText("Discard changes, leave as it was.");
        btnCancel.addActionListener(new ButtonHandler(ButtType.CANCEL, this));
        this.getContentPane().add(btnCancel);
    }

    void setNrp(boolean b) {
        if (b) {
            int i = 0;
            while (i < 7) {
                this.nrp.get(i).setModel(new DefaultComboBoxModel<String>(nRingMark));
                ++i;
            }
        } else {
            int i = 0;
            while (i < 7) {
                this.nrp.get(i).setModel(new DefaultComboBoxModel<String>(indices));
                ++i;
            }
        }
    }

    int validateRotors() {
        int[] rotArray = new int[rotors.length];
        int i = 0;
        while (i < rotors.length) {
            rotArray[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 8) {
            int k = this.rot.get(i).getSelectedIndex();
            if (rotArray[k] == -1) {
                return k;
            }
            rotArray[k] = -1;
            ++i;
        }
        return -4;
    }

    int validateNRings() {
        int[] ringArray = new int[11];
        int i = 0;
        while (i < 11) {
            ringArray[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 7) {
            int k = this.nr.get(i).getSelectedIndex();
            if (ringArray[k] == -1) {
                return k;
            }
            ringArray[k] = -1;
            ++i;
        }
        return -4;
    }

    void setBox() {
        int k = 0;
        int ri = 0;
        if (this.validateRotors() == -1) {
            System.out.println("Cannot place the same rotor in more than one slot!");
            return;
        }
        if (this.validateNRings() == -1) {
            System.out.println("Cannot place same notched ring in more than one slot!");
            return;
        }
        int i = 0;
        while (i < 8) {
            this.box.setRotor((String)this.rot.get(i).getSelectedItem(), i);
            this.box.setRotorStart(i, (byte)this.lring.get(i).getSelectedIndex());
            if (i != 7) {
                this.box.setNRing(i, this.nr.get(i).getSelectedIndex());
                k = this.nrp.get(i).getSelectedIndex();
                ri = i < 3 ? i : i + 1;
                this.box.setNRingAlphPos(i, this.lring.get(ri).getSelectedIndex());
                this.box.setNRingPos(i, k);
            }
            ++i;
        }
    }

    void setBox(Key key) {
        if (key.validateRotors() == -1) {
            System.out.println("Cannot place the same rotor  in more than one slot!");
            return;
        }
        if (key.validateNRings() == -1) {
            System.out.println("Cannot place the same notched ring in more than one slot!");
            return;
        }
        this.oldNrPos = !key.useNewNRings();
        this.box.setBox(key);
    }

    void getBox() {
        int i = 0;
        while (i < 8) {
            this.rot.get(i).setSelectedItem(this.box.getRotor(i));
            this.lring.get(i).setSelectedIndex(this.box.getRotorStart(i));
            if (i != 7) {
                this.nr.get(i).setSelectedIndex(this.box.getNRing(i) - 1);
                this.nrp.get(i).setSelectedIndex(this.box.getNRingPos(i));
            }
            ++i;
        }
        this.ksim.repaintWin();
    }

    void setNewBox(Box b) {
        this.box = b;
    }

    void setDefault() {
        int i = 0;
        while (i < 8) {
            this.rot.get(i).setSelectedIndex(i);
            this.lring.get(i).setSelectedIndex(0);
            ++i;
        }
        i = 0;
        while (i < 7) {
            this.nr.get(i).setSelectedIndex(i);
            this.nrp.get(i).setSelectedIndex(0);
            ++i;
        }
        this.ksim.repaintWin();
    }

    void resetCounter() {
        this.box.resetCounter();
    }

    void saveKeyToFile() {
        File of = null;
        PrintWriter prout = null;
        int result = this.fc.showSaveDialog(null);
        switch (result) {
            case 1: {
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(null, "Problem opening or saving file", "Could not save to this file", 0);
                break;
            }
            case 0: {
                of = this.fc.getSelectedFile();
                StringBuffer srot = new StringBuffer("");
                StringBuffer spos = new StringBuffer("");
                StringBuffer nrgs = new StringBuffer("");
                StringBuffer npos = new StringBuffer("");
                try {
                    try {
                        prout = of.getName().endsWith(".txt") ? new PrintWriter(of) : new PrintWriter(String.valueOf(of.getName()) + ".txt");
                        int i = 0;
                        while (i < 8) {
                            srot.append((String)this.rot.get(i).getSelectedItem());
                            spos.append((String)this.lring.get(i).getSelectedItem());
                            if (i != 7) {
                                int k = this.nr.get(i).getSelectedIndex() + 1;
                                nrgs.append(String.format("%02d", k));
                                k = this.nrp.get(i).getSelectedIndex() + 1;
                                npos.append(String.format("%02d", k));
                            }
                            ++i;
                        }
                        prout.println(srot.toString());
                        prout.println(spos.toString());
                        prout.println(nrgs.toString());
                        prout.println(npos.toString());
                        prout.close();
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(this.contentPane, "Could not save key settings " + ex.getMessage(), "Error saving key file", 0);
                        if (prout == null) break;
                        prout.close();
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (prout != null) {
                        prout.close();
                    }
                    throw throwable;
                }
                if (prout == null) break;
                prout.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void loadKeyFromFile() {
        inf = null;
        rin = null;
        result = this.fc.showOpenDialog(null);
        switch (result) {
            case 1: {
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(null, "Problem opening file for reading", "Could not read from file", 0);
                break;
            }
            case 0: {
                i = 0;
                k = 0;
                l = 0;
                inf = this.fc.getSelectedFile();
                rin = new BufferedReader(new FileReader(inf));
                srot = rin.readLine();
                if (srot != null) ** GOTO lbl28
                JOptionPane.showMessageDialog(this.contentPane, "Malformed/incomplete file \"" + inf.getName() + "\"", "Error restoring key from file " + inf.getName(), 0);
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl28:
                // 2 sources

                srot = srot.toUpperCase();
                if (!srot.matches("[A-M]{8}")) ** GOTO lbl103
                spos = rin.readLine();
                nrgs = rin.readLine();
                npos = rin.readLine();
                basicStart = rin.readLine();
                if (spos != null && nrgs != null && npos != null) ** GOTO lbl44
                JOptionPane.showMessageDialog(this.contentPane, "Malformed or incomplete file \"" + inf.getName() + "\"", "Error restoring key from file " + inf.getName(), 0);
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl44:
                // 2 sources

                this.oldNrPos = npos.length() >= 16 && npos.substring(14).equals("OF") != false;
                i = 0;
                while (i < 8) {
                    this.rot.get(i).setSelectedItem(srot.substring(i, i + 1));
                    tmp = spos.substring(2 * i, 2 * i + 2);
                    this.lring.get(i).setSelectedItem(tmp);
                    ++i;
                }
                i = 0;
                while (i < 7) {
                    tmp = nrgs.substring(2 * i, 2 * i + 2);
                    this.nr.get(i).setSelectedIndex(Integer.parseInt(tmp) - 1);
                    tmp = npos.substring(2 * i, 2 * i + 2);
                    k = Integer.parseInt(tmp) - 1;
                    if (this.oldNrPos && (k = (k - this.lring.get(l = i < 3 ? i : i + 1).getSelectedIndex()) % 36) < 0) {
                        k += 36;
                    }
                    this.nrp.get(i).setSelectedIndex(k);
                    ++i;
                }
                if (this.validateRotors() == -4) ** GOTO lbl73
                JOptionPane.showMessageDialog(this.contentPane, "Attempt to use same rotor twice: \"" + inf.getName() + "\"", "Error restoring key from file " + inf.getName(), 0);
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl73:
                // 2 sources

                if (this.validateNRings() == -4) ** GOTO lbl83
                JOptionPane.showMessageDialog(this.contentPane, "Attempt to use same Notch Ring twice: \"" + inf.getName() + "\"", "Error restoring key from file " + inf.getName(), 0);
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl83:
                // 2 sources

                this.setBox();
                if (basicStart != null && basicStart.length() == 7) {
                    this.box.setMsgKey(basicStart);
                } else {
                    this.box.setMsgKey("AAAAAAA");
                }
                keyTitle = inf.getName();
                i = keyTitle.lastIndexOf(".");
                keyTitle = keyTitle.substring(0, i);
                this.ksim.setKeyTitle(keyTitle);
                this.ksim.adjustTitle(keyTitle);
                this.ksim.repaintWin();
                rin.close();
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl103:
                // 2 sources

                if (!srot.matches(" \\+-{59,73}\\+")) ** GOTO lbl129
                skey = this.parseSingleKey(rin);
                if (skey != null) {
                    this.setBox();
                    this.box.resetCounter();
                    keyTitle = String.valueOf(this.numSysInd) + " " + inf.getName();
                    i = keyTitle.lastIndexOf(".");
                    keyTitle = keyTitle.substring(0, i);
                    this.ksim.setKeyTitle(keyTitle);
                    this.ksim.adjustTitle(keyTitle);
                    this.box.setMsgKey("AAAAAAA");
                    if (this.validateKey()) {
                        JOptionPane.showMessageDialog(this.contentPane, "LETTER CHECK validated for this key.", "Key verification success", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.contentPane, "Problem setting the key - checksum failed! ", "Error setting key from file " + inf.getName(), 0);
                    }
                    this.box.setMsgKey(skey);
                    this.ksim.repaintWin();
                }
                rin.close();
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl129:
                // 2 sources

                day = 0;
                sbuf = srot;
                spat5 = " (TOP SECRET|SECRET|CONFIDENTIAL|RESTRICTED)\\s+(CRYPTO)?\\s+(\\w+)\\s+(\\d\\d\\d\\d)?\\s+([A-Z]{5})?\\s+(JANUARY|FEBRUARY|MARCH|APRIL|MAY|JUNE|JULY|AUGUST|SEPTEMBER|OCTOBER|NOVEMBER|DECEMBER) (\\d\\d\\d\\d)";
                spat5l = " (TOP SECRET|SECRET|CONFIDENTIAL|RESTRICTED)\\s+(\\w.+)\\s+(January|February|March|April|May|June|July|August|September|October|November|December) (\\d\\d\\d\\d)";
                pot = Pattern.compile(" (TOP SECRET|SECRET|CONFIDENTIAL|RESTRICTED)\\s+(CRYPTO)?\\s+(\\w+)\\s+(\\d\\d\\d\\d)?\\s+([A-Z]{5})?\\s+(JANUARY|FEBRUARY|MARCH|APRIL|MAY|JUNE|JULY|AUGUST|SEPTEMBER|OCTOBER|NOVEMBER|DECEMBER) (\\d\\d\\d\\d)", 2);
                if (!sbuf.matches(" (TOP SECRET|SECRET|CONFIDENTIAL|RESTRICTED)\\s+(CRYPTO)?\\s+(\\w+)\\s+(\\d\\d\\d\\d)?\\s+([A-Z]{5})?\\s+(JANUARY|FEBRUARY|MARCH|APRIL|MAY|JUNE|JULY|AUGUST|SEPTEMBER|OCTOBER|NOVEMBER|DECEMBER) (\\d\\d\\d\\d)") && !sbuf.matches(" (TOP SECRET|SECRET|CONFIDENTIAL|RESTRICTED)\\s+(\\w.+)\\s+(January|February|March|April|May|June|July|August|September|October|November|December) (\\d\\d\\d\\d)")) ** GOTO lbl192
                mp = pot.matcher(sbuf);
                if (!mp.matches()) ** GOTO lbl181
                sheetClass = mp.group(1);
                netName = mp.group(3).trim();
                this.numSysInd = mp.group(4);
                mon = mp.group(6);
                year = mp.group(7);
                this.cal.set(1, Integer.parseInt(year));
                this.cal.set(2, this.getMonthLong(mon));
                day = this.cal.get(5);
                do {
                    ans = JOptionPane.showInputDialog(this, "Enter the day of the month (between 1 and " + this.cal.getActualMaximum(5) + ")" + " to select the key (must be 1 or 2 digits):", String.format("%d", new Object[]{day}));
                    if ((ans = ans.trim()).matches("\\d{1,2}") && (day = Integer.parseInt(ans)) >= 1 && day <= this.cal.getActualMaximum(5)) break;
                    JOptionPane.showMessageDialog(this, "Wrong format for the entered day: " + ans, "Error entering the day of the month ", 0);
                } while (day < 1 || day > this.cal.getActualMaximum(5));
                mon = this.monthsShort[this.getMonthLong(mon)];
                this.keyNumSysInd = "";
                skey = this.parseMonthlyKeysheet(rin, day, String.valueOf(mon) + "-" + year, netName);
                if (skey != null) {
                    this.setBox();
                    if (this.numSysInd == null || this.numSysInd.equals("")) {
                        this.numSysInd = this.keyNumSysInd == null || this.keyNumSysInd.equals("") != false ? "" : this.keyNumSysInd;
                    }
                    keyTitle = String.valueOf(this.numSysInd) + " " + inf.getName();
                    i = keyTitle.lastIndexOf(".");
                    keyTitle = keyTitle.substring(0, i);
                    this.ksim.setKeyTitle(keyTitle);
                    this.ksim.adjustTitle(keyTitle);
                    this.box.setMsgKey("AAAAAAA");
                    if (this.validateKey()) {
                        JOptionPane.showMessageDialog(this.contentPane, "LETTER CHECK validated for this key.", "Key verification success", 1);
                    } else {
                        JOptionPane.showMessageDialog(this.contentPane, "Problem setting the key - checksum failed! ", "Error setting key from file " + inf.getName(), 0);
                    }
                    this.box.resetCounter();
                    this.box.setMsgKey(skey);
                    this.ksim.repaintWin();
                } else {
                    JOptionPane.showMessageDialog(this.contentPane, "Error setting key from monthly sheet! ", "Error setting key from file " + inf.getName(), 0);
                }
                rin.close();
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl181:
                // 2 sources

                System.out.println("Matched 1st line of monthly, but mp bad?");
                System.out.println("\"" + sbuf + "\"");
                rin.close();
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
lbl192:
                // 2 sources

                JOptionPane.showMessageDialog(this.contentPane, "Problem setting the key - unrecognizable first line \"" + sbuf + "\"", "Error setting key from file " + inf.getName(), 0);
                rin.close();
                try {
                    if (rin != null) {
                        rin.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace(System.err);
                }
                return;
                catch (IOException ex) {
                    try {
                        JOptionPane.showMessageDialog(this.contentPane, "Could not restore key settings: " + ex.getMessage(), "Error restoring key from file " + inf.getName(), 0);
                    }
                    catch (Throwable var25_40) {
                        try {
                            if (rin != null) {
                                rin.close();
                            }
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace(System.err);
                        }
                        throw var25_40;
                    }
                    try {
                        if (rin == null) break;
                        rin.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace(System.err);
                    }
                    break;
                }
            }
        }
    }

    private boolean validateKey() {
        String lll = "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL";
        BoxMode bm = this.box.getBoxMode();
        boolean res = true;
        if (this.oldNrPos) {
            this.box.setNewNRings(false);
        } else {
            this.box.setNewNRings(true);
        }
        this.box.setBoxMode(BoxMode.P);
        this.box.setMsgKey("AAAAAAA");
        this.box.setBoxMode(BoxMode.E);
        String chk = this.box.encryptString("LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL");
        chk = chk.trim();
        this.box.setBoxMode(bm);
        this.box.resetCounter();
        int i = chk.indexOf(this.checksum[0]);
        if (i != 42) {
            res = false;
        }
        if ((i = chk.indexOf(this.checksum[1])) != 48) {
            res = false;
        }
        if (!res) {
            this.box.dumpCage();
        }
        return res;
    }

    private String parseSingleKey(BufferedReader bir) {
        String bStart;
        String keyTitle;
        block42: {
            Matcher mp;
            Pattern pot;
            String sbuf;
            block41: {
                block40: {
                    int k;
                    int i;
                    String tmp;
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                String spatTitle;
                                                block32: {
                                                    sbuf = null;
                                                    tmp = null;
                                                    keyTitle = null;
                                                    spatTitle = " \\|\\s+(.*)\\s+(\\d{1,2}-\\w{3}-\\d{4})\\s+\\|\\s+1  2  3  4  5  6  7  8 \\|";
                                                    String spatRotor = " \\| ROTOR\\s+\\|\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+\\|";
                                                    String spatRAlpha = " \\| ROTOR ALPHABET POSITION .+ (\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s\\|";
                                                    String spatNRing = " \\| NOTCH[ED]* RING\\s+\\|\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+\\|";
                                                    String spatNRPos = " \\| NOTCH[ED]* RING POSITION \\s+\\|\\s+((\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+)\\|";
                                                    String spatNRPosNew = " \\| NOTCH[ED]* RING POSITION \\s+\\|\\s+(([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+)\\|";
                                                    String spatBStart = " \\| DAILY ROTOR ALIGNMENT .+(([A-Z]\\p{Blank}+){7})\\|";
                                                    String spatOldBStart = " \\| BASIC START POSITION .+(([A-Z]\\p{Blank}+){7})\\|";
                                                    String spatSInd = " \\| SYSTEM INDICATOR\\s+\\|\\s+([A-Z]{5})\\s+([0-9]{4,5})\\s+\\|";
                                                    String spatChecksum = " \\|\\s+36-45 LETTER CHECK\\s+\\|\\s+([A-Z]{5})[\\s/]+([A-Z]{5})\\s+\\|";
                                                    bStart = "";
                                                    sbuf = bir.readLine();
                                                    if (sbuf != null) break block32;
                                                    return null;
                                                }
                                                pot = Pattern.compile(spatTitle);
                                                mp = pot.matcher(sbuf);
                                                if (mp.matches()) {
                                                    String net = mp.group(1);
                                                    i = net.length() - 1;
                                                    while (net.charAt(i) == ' ') {
                                                        --i;
                                                    }
                                                    keyTitle = net.substring(0, i + 1);
                                                    keyTitle = String.valueOf(keyTitle) + " ";
                                                    keyTitle = String.valueOf(keyTitle) + mp.group(2);
                                                    break block33;
                                                }
                                                System.err.println("Malformed single-key file - bad Net-line.");
                                                System.err.println("\"" + sbuf + "\"");
                                                return null;
                                            }
                                            sbuf = bir.readLine();
                                            if (sbuf != null && sbuf.matches(" \\|-{33,44}\\+-------------------------\\|")) break block34;
                                            JOptionPane.showMessageDialog(this.contentPane, "Incorrect separator line (expected ------)", "Error restoring key from Single-Key file ", 0);
                                            return null;
                                        }
                                        sbuf = bir.readLine();
                                        pot = Pattern.compile(" \\| ROTOR\\s+\\|\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+\\|");
                                        mp = pot.matcher(sbuf);
                                        if (mp.matches()) {
                                            i = 0;
                                            while (i < 8) {
                                                this.rot.get(i).setSelectedItem(mp.group(i + 1));
                                                ++i;
                                            }
                                            break block35;
                                        }
                                        JOptionPane.showMessageDialog(this.contentPane, "Malformed ROTOR line! " + sbuf, "Error restoring key from Single-Key file ", 0);
                                        return null;
                                    }
                                    if (this.validateRotors() == -4) break block36;
                                    JOptionPane.showMessageDialog(this.contentPane, "Attempt to use same rotor twice!", "Error restoring key from file ", 0);
                                    return null;
                                }
                                sbuf = bir.readLine();
                                pot = Pattern.compile(" \\| ROTOR ALPHABET POSITION .+ (\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s(\\d{2})\\s\\|");
                                mp = pot.matcher(sbuf);
                                if (mp.matches()) {
                                    i = 0;
                                    while (i < 8) {
                                        this.lring.get(i).setSelectedItem(mp.group(i + 1));
                                        ++i;
                                    }
                                    break block37;
                                }
                                JOptionPane.showMessageDialog(this.contentPane, "Malformed ROTOR ALPHABET POS line " + sbuf, "Error restoring key from Single-Key file ", 0);
                                return null;
                            }
                            sbuf = bir.readLine();
                            pot = Pattern.compile(" \\| NOTCH[ED]* RING\\s+\\|\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+\\|");
                            mp = pot.matcher(sbuf);
                            if (mp.matches()) {
                                i = 0;
                                while (i < 7) {
                                    k = Integer.parseInt(mp.group(i + 1).trim()) - 1;
                                    this.nr.get(i).setSelectedIndex(k);
                                    ++i;
                                }
                                break block38;
                            }
                            JOptionPane.showMessageDialog(this.contentPane, "Malformed NOTCH RINGS line " + sbuf, "Error restoring key from Single-Key file ", 0);
                            System.out.println("\"" + sbuf + "\"");
                            return null;
                        }
                        if (this.validateNRings() == -4) break block39;
                        JOptionPane.showMessageDialog(this.contentPane, "Attempt to use same Notched Ring twice!", "Error restoring key from file ", 0);
                        return null;
                    }
                    try {
                        sbuf = bir.readLine();
                        pot = Pattern.compile(" \\| NOTCH[ED]* RING POSITION \\s+\\|\\s+((\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+(\\d\\d)\\p{Blank}+)\\|");
                        mp = pot.matcher(sbuf);
                        if (mp.matches()) {
                            i = 0;
                            while (i < 7) {
                                tmp = mp.group(i + 2);
                                int l = i < 3 ? i : i + 1;
                                k = Integer.parseInt(tmp) - 1;
                                if ((k = (k - this.lring.get(l).getSelectedIndex()) % 36) < 0) {
                                    k += 36;
                                }
                                this.nrp.get(i).setSelectedIndex(k);
                                ++i;
                            }
                            break block40;
                        }
                        pot = Pattern.compile(" \\| NOTCH[ED]* RING POSITION \\s+\\|\\s+(([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+([A-Z]\\+?)\\p{Blank}+)\\|");
                        mp = pot.matcher(sbuf);
                        if (mp.matches()) {
                            i = 0;
                            while (i < 7) {
                                this.nrp.get(i).setSelectedItem(mp.group(i + 2));
                                ++i;
                            }
                            break block40;
                        }
                        JOptionPane.showMessageDialog(this.contentPane, "Malformed NOTCH RING POS line\n" + sbuf, "Error restoring key from Single-Key file ", 0);
                        return null;
                    }
                    catch (IOException exep5) {
                        System.err.println("Could not read file: " + exep5.getMessage());
                        exep5.getStackTrace();
                        return null;
                    }
                }
                sbuf = bir.readLine();
                pot = Pattern.compile(" \\| DAILY ROTOR ALIGNMENT .+(([A-Z]\\p{Blank}+){7})\\|");
                mp = pot.matcher(sbuf);
                if (mp.matches()) {
                    bStart = mp.group(1).replaceAll("\\s", "");
                    break block41;
                }
                pot = Pattern.compile(" \\| BASIC START POSITION .+(([A-Z]\\p{Blank}+){7})\\|");
                mp = pot.matcher(sbuf);
                if (mp.matches()) {
                    bStart = mp.group(1).replaceAll("\\s", "");
                    break block41;
                }
                JOptionPane.showMessageDialog(this.contentPane, "Malformed BASIC START line " + sbuf, "Error restoring key from Single-Key file ", 0);
                return null;
            }
            sbuf = bir.readLine();
            sbuf = bir.readLine();
            pot = Pattern.compile(" \\| SYSTEM INDICATOR\\s+\\|\\s+([A-Z]{5})\\s+([0-9]{4,5})\\s+\\|");
            mp = pot.matcher(sbuf);
            if (mp.matches()) {
                this.charSysInd = mp.group(1);
                this.numSysInd = mp.group(2);
            } else {
                pot = Pattern.compile(" \\|\\s+36-45 LETTER CHECK\\s+\\|\\s+([A-Z]{5})[\\s/]+([A-Z]{5})\\s+\\|");
                mp = pot.matcher(sbuf);
                if (mp.matches()) {
                    this.checksum[0] = mp.group(1).replaceAll("\\s", "");
                    this.checksum[1] = mp.group(2).replaceAll("\\s", "");
                    this.charSysInd = "";
                    this.numSysInd = "";
                    this.keyChSysInd = "";
                    this.keyNumSysInd = "";
                    this.ksim.setKeyTitle(keyTitle);
                    this.ksim.adjustTitle(keyTitle);
                    return bStart;
                }
                JOptionPane.showMessageDialog(this.contentPane, "Malformed System Indicator line " + sbuf, "Error restoring key from Single-Key file ", 0);
                this.keyChSysInd = "";
                this.charSysInd = "";
                this.keyNumSysInd = "";
                this.numSysInd = "";
            }
            sbuf = bir.readLine();
            sbuf = bir.readLine();
            pot = Pattern.compile(" \\|\\s+36-45 LETTER CHECK\\s+\\|\\s+([A-Z]{5})[\\s/]+([A-Z]{5})\\s+\\|");
            mp = pot.matcher(sbuf);
            if (mp.matches()) {
                this.checksum[0] = mp.group(1).replaceAll("\\s", "");
                this.checksum[1] = mp.group(2).replaceAll("\\s", "");
                break block42;
            }
            JOptionPane.showMessageDialog(this.contentPane, "Malformed LETTER CHECK line " + sbuf, "Error restoring key from Single-Key file ", 0);
            return null;
        }
        this.ksim.setKeyTitle(keyTitle);
        this.ksim.adjustTitle(keyTitle);
        return bStart;
    }

    private final int getMonthLong(String name) {
        String n = name.toUpperCase();
        int i = 0;
        while (i < 12) {
            String m = this.monthsLong[i].toUpperCase();
            if (m.equals(n)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final int getMonthShort(String name) {
        String n = name.toUpperCase();
        int i = 0;
        while (i < 12) {
            String m = this.monthsShort[i].toUpperCase();
            if (m.equals(n)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseMonthlyKeysheet(BufferedReader bir, int day, String date, String net) {
        block25: {
            block24: {
                loop = 31;
                sbuf = "";
                keyTitle = String.valueOf(net) + " " + day + "-" + date;
                bStart = new StringBuffer();
                spatH1 = " \\|\\s*DAY\\s*\\|\\s+ROTORS\\s+\\|\\s+NOTCH(ED)? RINGS\\s+\\|.*";
                spatH2 = " \\|\\s+\\|\\s+(\\d\\s+){8}\\|\\s+(\\d\\s+){7}\\s*\\|\\s*(POSITION|ALIGNMENT)\\s*\\|\\s*(CHK GRPS|CHECK GRP|CHECK)\\s*\\|\\s*(IND\\w*)?\\s*\\|?";
                spatHsep = " \\|-{3,5}\\+-{20,27}\\+-{20,30}\\+-{11,18}\\+-+.*\\|";
                spatDay1 = " \\|\\s*(\\d{1,2})\\s*\\|\\s*([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s*\\|\\s*(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s*\\|\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+([A-Z])\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+\\|\\s*([A-Z]{5}) ([A-Z]{5})\\s*\\|\\s*([A-Z]{5})?\\s*\\|?";
                spatDay2 = " \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?";
                spatDay2N = " \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?";
                spatDay2Nfull = " \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})\\s*\\|";
                this.keyChSysInd = "";
                this.keyNumSysInd = "";
                try {
                    sbuf = bir.readLine();
                    sbuf = bir.readLine();
                    if (sbuf == null || !sbuf.matches(" -{70,97}")) {
                        System.out.println("Header Separator wrong");
                        System.out.println("\"" + sbuf + "\"");
                        return null;
                    }
                    sbuf = bir.readLine();
                    if (sbuf == null || !sbuf.matches(" \\|\\s*DAY\\s*\\|\\s+ROTORS\\s+\\|\\s+NOTCH(ED)? RINGS\\s+\\|.*")) {
                        System.out.println("Header line1 wrong");
                        System.out.println("\"" + sbuf + "\"");
                        return null;
                    }
                    sbuf = bir.readLine();
                    if (sbuf == null || !sbuf.matches(" \\|\\s+\\|\\s+(\\d\\s+){8}\\|\\s+(\\d\\s+){7}\\s*\\|\\s*(POSITION|ALIGNMENT)\\s*\\|\\s*(CHK GRPS|CHECK GRP|CHECK)\\s*\\|\\s*(IND\\w*)?\\s*\\|?")) {
                        System.out.println("Header line2 wrong");
                        System.out.println("\"" + sbuf + "\"");
                        return null;
                    }
                    sbuf = bir.readLine();
                    if (sbuf == null || !sbuf.matches(" \\|-{3,5}\\+-{20,27}\\+-{20,30}\\+-{11,18}\\+-+.*\\|")) {
                        System.out.println("Header last sep line wrong");
                        System.out.println("\"" + sbuf + "\"");
                        return null;
                    }
                    pot1 = Pattern.compile(" \\|\\s*(\\d{1,2})\\s*\\|\\s*([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s*\\|\\s*(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s*\\|\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+([A-Z])\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+\\|\\s*([A-Z]{5}) ([A-Z]{5})\\s*\\|\\s*([A-Z]{5})?\\s*\\|?", 2);
                    pot2 = Pattern.compile(" \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?", 2);
                    pot2n = Pattern.compile(" \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?", 2);
                    do {
                        block21: {
                            if ((sbuf = bir.readLine()) == null || !sbuf.matches(" \\|\\s*(\\d{1,2})\\s*\\|\\s*([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s+([A-M])\\s*\\|\\s*(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s+(\\d{1,2})\\s*\\|\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+([A-Z])\\s*([A-Z])\\s*([A-Z])\\s*([A-Z])\\s+\\|\\s*([A-Z]{5}) ([A-Z]{5})\\s*\\|\\s*([A-Z]{5})?\\s*\\|?")) {
                                System.out.println("Day1 line wrong");
                                System.out.println("\"" + sbuf + "\"");
                                return null;
                            }
                            mp = pot1.matcher(sbuf);
                            if (!mp.matches()) {
                                System.err.println("Day1 line - cannot match?!");
                                System.err.println("\"" + sbuf + "\"");
                                return null;
                            }
                            i = Integer.parseInt(mp.group(1));
                            if (i != day) break block21;
                            i = 0;
                            if (true) ** GOTO lbl95
                        }
                        sbuf = bir.readLine();
                    } while (--loop > 0);
lbl56:
                    // 3 sources

                    while (true) {
                        block22: {
                            block23: {
                                if (this.validateRotors() != -4) {
                                    System.err.println("Rotors failed validation, duplicate use!");
                                    return null;
                                }
                                if (this.validateNRings() != -4) {
                                    System.err.println("Notched Rings failed validation, duplicate use!");
                                    return null;
                                }
                                sbuf = bir.readLine();
                                if (sbuf == null || !sbuf.matches(" \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?") && !sbuf.matches(" \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})?\\s*\\|?")) break block22;
                                mp = pot2.matcher(sbuf);
                                if (!mp.matches()) break block23;
                                this.oldNrPos = true;
                                i = 0;
                                if (true) ** GOTO lbl114
                            }
                            mp = pot2n.matcher(sbuf);
                            if (!mp.matches()) {
                                System.err.println("Weird: recognized Day2 line but cannot match?!");
                                return null;
                            }
                            this.oldNrPos = false;
                            i = 0;
                            if (true) ** GOTO lbl129
                        }
                        System.out.println("Day 2 line wrong");
                        System.out.println("\"" + sbuf + "\"");
                        return null;
                    }
                }
                catch (PatternSyntaxException exep5) {
                    System.err.println("Could not read file: error in regular pattern " + exep5.getMessage());
                    exep5.getStackTrace();
                    return null;
                }
                catch (IOException exep6) {
                    System.err.println("Could not read file: IO error " + exep6.getMessage());
                    exep6.getStackTrace();
                    return null;
                }
                do {
                    this.rot.get(i).setSelectedItem(mp.group(2 + i));
                    ++i;
lbl95:
                    // 2 sources

                } while (i < 8);
                i = 0;
                while (i < 7) {
                    this.nr.get(i).setSelectedIndex(Integer.parseInt(mp.group(i + 10)) - 1);
                    bStart.append(mp.group(i + 17));
                    ++i;
                }
                this.checksum[0] = mp.group(24).trim();
                this.checksum[1] = mp.group(25).trim();
                if (!sbuf.matches(" \\|\\s+\\|\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+(\\d{2})\\s+\\|\\s+([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*([A-Z]\\+?)\\s*\\|\\s+\\|\\s+\\|\\s*([0-9]{4,5})\\s*\\|")) break block24;
                this.keyChSysInd = mp.group(26).trim();
                ** GOTO lbl56
            }
            this.keyChSysInd = "";
            ** while (true)
            do {
                this.lring.get(i).setSelectedItem(mp.group(i + 1));
                ++i;
lbl114:
                // 2 sources

            } while (i < 8);
            i = 0;
            while (i < 7) {
                tmp = mp.group(i + 9);
                l = i < 3 ? i : i + 1;
                k = Integer.parseInt(tmp) - 1;
                if ((k = (k - this.lring.get(l).getSelectedIndex()) % 36) < 0) {
                    k += 36;
                }
                this.nrp.get(i).setSelectedIndex(k);
                ++i;
            }
            break block25;
            do {
                this.lring.get(i).setSelectedItem(mp.group(i + 1));
                ++i;
lbl129:
                // 2 sources

            } while (i < 8);
            i = 0;
            while (i < 7) {
                this.nrp.get(i).setSelectedItem(mp.group(i + 9));
                ++i;
            }
            this.keyNumSysInd = this.keyChSysInd.equals("") == false ? mp.group(16) : "";
        }
        this.ksim.setKeyTitle(keyTitle);
        this.ksim.adjustTitle(keyTitle);
        return bStart.toString();
    }

    void zeroizeKeyFile() {
    }

    private static enum ButtType {
        SET,
        SAVE,
        LOAD,
        DELETE,
        CANCEL,
        CLIP;

    }

    private class ButtonHandler
    implements ActionListener {
        private ButtType button;
        private K4Panel panel;
        String skey;

        ButtonHandler(ButtType b, K4Panel kp) {
            this.button = b;
            this.panel = kp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = 0;
            switch (this.button) {
                case CANCEL: {
                    K4Panel.this.getBox();
                    this.panel.setVisible(false);
                    K4Panel.this.repaint();
                    return;
                }
                case DELETE: {
                    int resp = JOptionPane.showConfirmDialog(this.panel, "This will reset all the rotors and settings to the default position.", "Warning!", 2);
                    if (resp == 0) {
                        this.panel.setDefault();
                        K4Panel.this.setBox();
                        this.skey = "AAAAAAA";
                        K4Panel.this.box.setMsgKey(this.skey);
                        K4Panel.this.ksim.repaintWin();
                    }
                    K4Panel.this.ksim.adjustTitle(null);
                    this.panel.setVisible(false);
                    K4Panel.this.repaint();
                    return;
                }
                case SAVE: {
                    result = K4Panel.this.validateRotors();
                    if (result != -4) {
                        JOptionPane.showMessageDialog(null, "You cannot select the same rotor \"" + rotors[result] + "\" for more" + " than one slot!", "Attempt to put same rotor in multiple slots", 0);
                        return;
                    }
                    result = K4Panel.this.validateNRings();
                    if (result != -4) {
                        JOptionPane.showMessageDialog(null, "You cannot attach the same Notched Ring #" + nrings[result] + " to more" + " than one rotor!", "Attempt to use same Notched Ring twice", 0);
                        return;
                    }
                    K4Panel.this.setBox();
                    this.skey = "AAAAAAA";
                    K4Panel.this.saveKeyToFile();
                    K4Panel.this.box.setMsgKey(this.skey);
                    this.panel.setVisible(false);
                    K4Panel.this.ksim.adjustTitle(null);
                    K4Panel.this.ksim.repaintWin();
                    return;
                }
                case SET: {
                    result = K4Panel.this.validateRotors();
                    if (result != -4) {
                        JOptionPane.showMessageDialog(null, "You cannot select the same rotor \"" + rotors[result] + "\" for more" + " than one slot!", "Attempt to put same rotor in multiple slots", 0);
                        return;
                    }
                    result = K4Panel.this.validateNRings();
                    if (result != -4) {
                        JOptionPane.showMessageDialog(null, "You cannot attach the same Notched Ring #" + nrings[result] + " to more" + " than one rotor!", "Attempt to use same Notched Ring twice", 0);
                        return;
                    }
                    K4Panel.this.setBox();
                    this.skey = "AAAAAAA";
                    K4Panel.this.box.setMsgKey(this.skey);
                    this.panel.setVisible(false);
                    K4Panel.this.ksim.adjustTitle(null);
                    K4Panel.this.ksim.repaintWin();
                    return;
                }
                case LOAD: {
                    K4Panel.this.loadKeyFromFile();
                    this.panel.setVisible(false);
                    K4Panel.this.ksim.repaintWin();
                    break;
                }
                default: {
                    System.out.println("Got impossible enum " + (Object)((Object)this.button));
                    System.exit(-2);
                }
            }
        }
    }

    private class CListen
    implements ComponentListener {
        private CListen() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            K4Panel.this.oldNrPos = false;
            K4Panel.this.getBox();
        }
    }

    public static enum RotorNames {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M;

    }

    class TxtFilter
    extends FileFilter {
        TxtFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            return filename.endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "*.txt";
        }
    }
}

