/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.K4Panel;
import gui.KL7Codebook;
import gui.KL7Rewire;
import gui.Kl7AutoType;
import gui.Kl7Clip;
import gui.Kl7Info;
import gui.MsgKeySet;
import gui.RepeatingKeyEventsFixer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import kl7.Box;
import kl7.BoxMode;
import kl7.Register;
import kl7.SavedState;

public class KL7Sim
extends JFrame {
    static final long serialVersionUID = 3315543L;
    final char FIG = (char)123;
    final char LET = (char)125;
    final char RPT = (char)126;
    final String digletters = "QWERTYUIOP";
    final String digits = "1234567890";
    final String allowedCust = "ABCDEFGHIJKLMPT";
    final int interCharDelay = 300;
    private static final Font font = new Font("Menlo", 1, 11);
    private static final Font fontCur = new Font("Courier New", 0, 15);
    final String pattern = "^((([A-MP]=)([A-Z0-9]{36}))|(([01][0-9]=)([01]{36})))";
    private JPanel contentPane;
    private JLayeredPane layeredPane;
    private JPanel layer1;
    private JPanel layer2;
    private JPanel layer3;
    private JPanel layer4;
    private String outputText;
    private String fullOutputText;
    private JTextField counterDisp;
    private JTextField outputTape;
    private JTextArea[] rwin;
    private JLabel bgPicture;
    private JLabel panelPopupLabel;
    private JLabel msgKeyLabel;
    private JLabel cntReset;
    private JLabel lblMode;
    private JLabel FIG_lamp;
    private JLabel LET_lamp;
    private JLabel clipBoardLabel;
    private JLabel lblModeRight;
    private JLabel lblModeLeft;
    private Box rbox;
    private K4Panel box;
    private MsgKeySet mkset;
    private Kl7AutoType kat;
    private Kl7Clip klp;
    private Kl7Info info;
    private Register bReg;
    private BoxMode bM;
    private MListen ml;
    private KeyboardInput kin;
    private MSimpleListener msl;
    private int encCounter = 0;
    private boolean customized = false;
    private String mainTitle = "KL-7 Simulator";
    private String title = null;
    private String custTitle = null;
    private String keyTitle = null;
    private final String savedStateFile = "kl7-savedstate.dat";
    private final String customFile = "kl7-custom.txt";
    private JButton btnExit;
    private JButton btnInfo;
    private JButton btnHelp;
    private JButton btnSoundToggle;
    private boolean abortRun = false;
    private boolean autoRun = false;
    private boolean playSound = true;
    private boolean addSpace = false;
    private boolean enableRPT = true;
    private boolean repeatNext = false;
    private Thread tRpt = null;
    Clip soundRun;
    Clip soundPlain;
    Clip soundCipher;
    Clip soundStart;
    Clip soundStop;
    File sndRun;
    File sndPlain;
    File sndCiph;
    File sndStart;
    File sndStop;
    InputStream isSndRun;
    InputStream isSndPlain;
    InputStream isSndCipher;
    InputStream isSndStart;
    InputStream isSndStop;
    AudioInputStream aisSndRun;
    AudioInputStream aisSndPlain;
    AudioInputStream aisSndCipher;
    AudioInputStream aisSndStart;
    AudioInputStream aisSndStop;
    AudioFormat audioFormat;
    DataLine.Info infoSnd;
    private KL7Codebook codeBook;
    private KL7Rewire reWire;
    private ImageIcon modeO;
    private ImageIcon modeP;
    private ImageIcon modeE;
    private ImageIcon modeD;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new RepeatingKeyEventsFixer().install();
                    KL7Sim frame = new KL7Sim();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        });
    }

    public KL7Sim() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.rbox = new Box();
        this.bReg = this.rbox.getReg();
        this.bM = this.rbox.getBoxMode();
        File cust = new File("kl7-custom.txt");
        if (cust.exists() && cust.isFile() && cust.canRead()) {
            this.customized = true;
            if (!this.doCustomization(cust)) {
                this.rbox = new Box();
                this.custTitle = null;
            }
        }
        this.codeBook = new KL7Codebook(this.rbox, this);
        this.reWire = new KL7Rewire(this);
        this.setMinimumSize(new Dimension(545, 565));
        this.title = String.valueOf(this.mainTitle) + " ";
        if (this.custTitle != null) {
            this.title = String.valueOf(this.title) + this.custTitle;
        }
        this.setTitle(this.title);
        this.setVisible(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setBounds(0, 0, 550, 597);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.bReg = this.rbox.getReg();
        this.LET_lamp = new JLabel("");
        this.LET_lamp.setBorder(null);
        this.LET_lamp.setBackground(Color.BLACK);
        this.LET_lamp.setAlignmentY(0.0f);
        this.LET_lamp.setHorizontalAlignment(0);
        this.LET_lamp.setToolTipText("Machine is in LETTERS mode");
        this.LET_lamp.setBounds(267, 340, 64, 40);
        this.LET_lamp.setOpaque(false);
        this.FIG_lamp = new JLabel("");
        this.FIG_lamp.setBorder(null);
        this.FIG_lamp.setBackground(Color.BLACK);
        this.FIG_lamp.setAlignmentY(0.0f);
        this.FIG_lamp.setHorizontalAlignment(0);
        this.FIG_lamp.setToolTipText("Machine is in FIGURES mode");
        this.FIG_lamp.setIcon(new ImageIcon("resources/kl7_FIG_lamp.png"));
        this.FIG_lamp.setBounds(266, 340, 64, 40);
        this.FIG_lamp.setOpaque(true);
        if (this.bReg == Register.FIG) {
            this.FIG_lamp.setVisible(true);
            this.LET_lamp.setVisible(false);
        } else {
            this.FIG_lamp.setVisible(false);
            this.LET_lamp.setVisible(true);
        }
        this.contentPane.add(this.FIG_lamp);
        this.contentPane.add(this.LET_lamp);
        this.kin = new KeyboardInput();
        URL imgURL = this.getClass().getResource("/kl7_FIG_lamp.png");
        if (imgURL != null) {
            this.FIG_lamp.setIcon(new ImageIcon(imgURL, "Lamp"));
        } else {
            System.err.println("Couldn't find file: /kl7_FIG_lamp.png");
        }
        this.outputText = "";
        this.fullOutputText = null;
        this.outputTape = new JTextField();
        this.outputTape.setToolTipText("Paper tape where output is printed. Click for output Clipboard.");
        this.outputTape.setOpaque(true);
        this.outputTape.setHorizontalAlignment(4);
        this.outputTape.setEditable(false);
        this.outputTape.setDragEnabled(false);
        this.outputTape.setFocusable(true);
        this.outputTape.setColumns(54);
        this.outputTape.setBorder(null);
        this.outputTape.setBackground(Color.WHITE);
        this.outputTape.setAlignmentX(1.0f);
        this.outputTape.setAlignmentY(0.5f);
        this.outputTape.setBounds(36, 530, 480, 24);
        this.outputTape.setText("");
        this.outputTape.setFont(fontCur);
        this.contentPane.add(this.outputTape);
        this.klp = new Kl7Clip(this);
        this.klp.setVisible(false);
        this.klp.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (KL7Sim.this.fullOutputText == null) {
                    KL7Sim.this.fullOutputText = KL7Sim.this.outputTape.getText();
                }
                if (KL7Sim.this.fullOutputText.indexOf(KL7Sim.this.outputTape.getText()) == -1) {
                    JOptionPane.showMessageDialog(KL7Sim.this.contentPane, "Got a problem: full output does not contain the print tape text", "Mismatch between print and stored output", 0);
                }
                KL7Sim.this.klp.setTextArea(KL7Sim.this.fullOutputText);
            }
        });
        this.outputTape.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (KL7Sim.this.rbox.getBoxMode() != BoxMode.O) {
                    KL7Sim.this.klp.setVisible(true);
                    KL7Sim.this.repaintWin();
                    KL7Sim.this.setCounterDisp();
                }
            }
        });
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setAlignmentY(0.0f);
        this.layeredPane.setAlignmentX(0.0f);
        this.contentPane.add(this.layeredPane);
        this.bgPicture = new JLabel("");
        this.bgPicture.setFocusable(false);
        this.bgPicture.setRequestFocusEnabled(false);
        this.bgPicture.setIcon(new ImageIcon("resources/kl7-overall_view.png"));
        this.bgPicture.setBounds(0, 0, 536, 560);
        this.bgPicture.setOpaque(false);
        imgURL = this.getClass().getResource("/kl7-overall_view.png");
        if (imgURL != null) {
            this.bgPicture.setIcon(new ImageIcon(imgURL, "Box"));
        } else {
            System.err.println("Couldn't find file: /kl7-overall_view.png");
        }
        this.layeredPane.add((Component)this.bgPicture, new Integer(0));
        this.layer1 = new JPanel();
        this.layer1.setLayout(null);
        this.layer1.setBounds(0, 0, 536, 560);
        this.layer1.setOpaque(false);
        this.layer1.setVisible(true);
        imgURL = this.getClass().getResource("/modeO.png");
        if (imgURL != null) {
            this.modeO = new ImageIcon(imgURL, "O");
        } else {
            System.err.println("Couldn't find file: /modeO.png");
            this.modeO = new ImageIcon("resources/modeO.png");
        }
        imgURL = this.getClass().getResource("/modeP.png");
        if (imgURL != null) {
            this.modeP = new ImageIcon(imgURL, "P");
        } else {
            System.err.println("Couldn't find file: /modeP.png");
            this.modeP = new ImageIcon("resources/modeP.png");
        }
        imgURL = this.getClass().getResource("/modeE.png");
        if (imgURL != null) {
            this.modeE = new ImageIcon(imgURL, "E");
        } else {
            System.err.println("Couldn't find file: /modeE.png");
            this.modeE = new ImageIcon("resources/modeE.png");
        }
        imgURL = this.getClass().getResource("/modeD.png");
        if (imgURL != null) {
            this.modeD = new ImageIcon(imgURL, "D");
        } else {
            System.err.println("Couldn't find file: /modeD.png");
            this.modeD = new ImageIcon("resources/modeD.png");
        }
        this.lblMode = new JLabel("");
        this.lblMode.setToolTipText("Machine mode: O[ff], P[laintext], E[ncrypt], D[ecrypt].");
        this.lblMode.setIcon(this.modeO);
        this.lblMode.setBorder(null);
        this.lblMode.setBounds(38, 395, 62, 93);
        this.lblMode.setOpaque(true);
        this.lblMode.setVisible(true);
        this.layer1.add(this.lblMode);
        this.lblModeRight = new JLabel("");
        this.lblModeRight.setHorizontalAlignment(2);
        this.lblModeRight.setToolTipText("Click here to turn machine ON (Plaintext mode)");
        this.lblModeRight.setBorder(null);
        this.lblModeRight.setOpaque(false);
        this.lblModeRight.setEnabled(true);
        this.lblModeRight.setForeground(Color.ORANGE);
        this.lblModeRight.setBounds(72, 400, 46, 69);
        this.lblModeLeft = new JLabel("");
        this.lblModeLeft.setHorizontalAlignment(4);
        this.lblModeLeft.setToolTipText("");
        this.lblModeLeft.setBorder(null);
        this.lblModeLeft.setOpaque(false);
        this.lblModeLeft.setEnabled(true);
        this.lblModeLeft.setVisible(false);
        this.lblModeLeft.setForeground(Color.ORANGE);
        this.lblModeLeft.setBounds(20, 400, 45, 69);
        this.msl = new MSimpleListener();
        this.lblModeRight.addMouseListener(this.msl);
        this.lblModeLeft.addMouseListener(this.msl);
        this.rwin = new JTextArea[8];
        this.rwin[0] = new JTextArea();
        this.rwin[0].setBounds(233, 240, 15, 48);
        this.rwin[0].setBackground(Color.BLACK);
        this.rwin[0].setForeground(Color.WHITE);
        this.rwin[0].setAlignmentX(0.5f);
        this.rwin[0].setAlignmentY(0.5f);
        this.rwin[0].setRows(3);
        this.rwin[0].setColumns(1);
        this.rwin[0].setVisible(true);
        this.rwin[0].setOpaque(true);
        this.rwin[0].setFont(font);
        this.rwin[0].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[0].setEditable(false);
        this.rwin[0].setFocusable(false);
        this.rwin[0].setText(this.createWinString(this.rbox.getRotorFullWin(0)));
        this.layer1.add(this.rwin[0]);
        this.rwin[1] = new JTextArea();
        this.rwin[1].setBounds(262, 240, 15, 48);
        this.rwin[1].setBackground(Color.BLACK);
        this.rwin[1].setForeground(Color.WHITE);
        this.rwin[1].setAlignmentX(0.5f);
        this.rwin[1].setAlignmentY(0.5f);
        this.rwin[1].setRows(3);
        this.rwin[1].setColumns(1);
        this.rwin[1].setVisible(true);
        this.rwin[1].setOpaque(true);
        this.rwin[1].setFont(font);
        this.rwin[1].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[1].setEditable(false);
        this.rwin[1].setFocusable(false);
        this.rwin[1].setText(this.createWinString(this.rbox.getRotorFullWin(1)));
        this.layer1.add(this.rwin[1]);
        this.rwin[2] = new JTextArea();
        this.rwin[2].setBounds(291, 240, 15, 48);
        this.rwin[2].setBackground(Color.BLACK);
        this.rwin[2].setForeground(Color.WHITE);
        this.rwin[2].setAlignmentX(0.5f);
        this.rwin[2].setAlignmentY(0.5f);
        this.rwin[2].setRows(3);
        this.rwin[2].setColumns(1);
        this.rwin[2].setVisible(true);
        this.rwin[2].setOpaque(true);
        this.rwin[2].setFont(font);
        this.rwin[2].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[2].setEditable(false);
        this.rwin[2].setFocusable(false);
        this.rwin[2].setText(this.createWinString(this.rbox.getRotorFullWin(2)));
        this.layer1.add(this.rwin[2]);
        this.rwin[4] = new JTextArea();
        this.rwin[4].setBounds(348, 240, 15, 48);
        this.rwin[4].setBackground(Color.BLACK);
        this.rwin[4].setForeground(Color.WHITE);
        this.rwin[4].setAlignmentX(0.5f);
        this.rwin[4].setAlignmentY(0.5f);
        this.rwin[4].setRows(3);
        this.rwin[4].setColumns(1);
        this.rwin[4].setVisible(true);
        this.rwin[4].setOpaque(true);
        this.rwin[4].setFont(font);
        this.rwin[4].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[4].setEditable(false);
        this.rwin[4].setFocusable(false);
        this.rwin[4].setText(this.createWinString(this.rbox.getRotorFullWin(4)));
        this.layer1.add(this.rwin[4]);
        this.rwin[5] = new JTextArea();
        this.rwin[5].setBounds(377, 240, 15, 48);
        this.rwin[5].setBackground(Color.BLACK);
        this.rwin[5].setForeground(Color.WHITE);
        this.rwin[5].setAlignmentX(0.5f);
        this.rwin[5].setAlignmentY(0.5f);
        this.rwin[5].setRows(3);
        this.rwin[5].setColumns(1);
        this.rwin[5].setVisible(true);
        this.rwin[5].setOpaque(true);
        this.rwin[5].setFont(font);
        this.rwin[5].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[5].setEditable(false);
        this.rwin[5].setFocusable(false);
        this.rwin[5].setText(this.createWinString(this.rbox.getRotorFullWin(5)));
        this.layer1.add(this.rwin[5]);
        this.rwin[6] = new JTextArea();
        this.rwin[6].setBounds(405, 240, 15, 48);
        this.rwin[6].setBackground(Color.BLACK);
        this.rwin[6].setForeground(Color.WHITE);
        this.rwin[6].setAlignmentX(0.5f);
        this.rwin[6].setAlignmentY(0.5f);
        this.rwin[6].setRows(3);
        this.rwin[6].setColumns(1);
        this.rwin[6].setVisible(true);
        this.rwin[6].setOpaque(true);
        this.rwin[6].setFont(font);
        this.rwin[6].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[6].setEditable(false);
        this.rwin[6].setFocusable(false);
        this.rwin[6].setText(this.createWinString(this.rbox.getRotorFullWin(6)));
        this.layer1.add(this.rwin[6]);
        this.rwin[7] = new JTextArea();
        this.rwin[7].setBounds(434, 240, 15, 48);
        this.rwin[7].setBackground(Color.BLACK);
        this.rwin[7].setForeground(Color.WHITE);
        this.rwin[7].setAlignmentX(0.5f);
        this.rwin[7].setAlignmentY(0.5f);
        this.rwin[7].setRows(3);
        this.rwin[7].setColumns(1);
        this.rwin[7].setVisible(true);
        this.rwin[7].setOpaque(true);
        this.rwin[7].setFont(font);
        this.rwin[7].setBorder(new LineBorder(Color.BLACK, 2));
        this.rwin[7].setEditable(false);
        this.rwin[7].setFocusable(false);
        this.rwin[7].setText(this.createWinString(this.rbox.getRotorFullWin(7)));
        this.layer1.add(this.rwin[7]);
        this.counterDisp = new JTextField();
        this.counterDisp.setBounds(360, 336, 42, 18);
        this.counterDisp.setBounds(356, 335, 46, 20);
        this.counterDisp.setColumns(4);
        this.counterDisp.setText("0013");
        this.counterDisp.setFont(new Font("Arial", 1, 14));
        this.counterDisp.setToolTipText("How many characters encrypted (and/or decrypted) since power-on.");
        this.counterDisp.setForeground(Color.WHITE);
        this.counterDisp.setEditable(false);
        this.counterDisp.setBackground(Color.BLACK);
        this.counterDisp.setBorder(new EtchedBorder(1, Color.LIGHT_GRAY, Color.GRAY));
        this.counterDisp.setHorizontalAlignment(0);
        this.cntReset = new JLabel("");
        this.cntReset.setBounds(415, 333, 45, 30);
        this.cntReset.setBorder(null);
        this.cntReset.setToolTipText("Click to reset the Counter to 0.");
        this.cntReset.setOpaque(false);
        this.cntReset.setVisible(true);
        this.kat = new Kl7AutoType(this, this.rbox);
        this.clipBoardLabel = new JLabel("");
        this.clipBoardLabel.setBounds(465, 345, 65, 80);
        this.clipBoardLabel.setBorder(null);
        this.clipBoardLabel.setToolTipText("Click to open Auto-typing window.");
        this.clipBoardLabel.setOpaque(false);
        this.clipBoardLabel.setVisible(true);
        this.layer1.add(this.counterDisp);
        this.layer1.add(this.cntReset);
        this.layer1.add(this.clipBoardLabel);
        this.layeredPane.add((Component)this.layer1, new Integer(1));
        this.box = new K4Panel(this.rbox, this);
        this.mkset = new MsgKeySet(this.rbox, this);
        this.mkset.setVisible(false);
        this.layer2 = new JPanel();
        this.layer2.setLayout(null);
        this.layer2.setBounds(0, 0, 536, 560);
        this.layer2.setOpaque(false);
        this.layer2.setBackground(Color.YELLOW);
        this.layer2.setVisible(true);
        this.layeredPane.add((Component)this.layer2, new Integer(2));
        this.panelPopupLabel = new JLabel("");
        this.panelPopupLabel.setBounds(223, 150, 236, 150);
        this.panelPopupLabel.setOpaque(false);
        this.panelPopupLabel.setVisible(true);
        this.panelPopupLabel.setToolTipText("Click to select and configure rotors.");
        this.panelPopupLabel.setBackground(Color.RED);
        this.layer2.add(this.panelPopupLabel);
        this.msgKeyLabel = new JLabel("");
        this.msgKeyLabel.setBounds(223, 303, 236, 28);
        this.msgKeyLabel.setOpaque(false);
        this.msgKeyLabel.setVisible(true);
        this.msgKeyLabel.setToolTipText("Click to set rotors (turn machine on first).");
        this.msgKeyLabel.setBackground(Color.RED);
        this.ml = new MListen(this.box, this.mkset, this.kat);
        this.panelPopupLabel.addMouseListener(this.ml);
        this.cntReset.addMouseListener(this.ml);
        this.msgKeyLabel.addMouseListener(this.ml);
        this.clipBoardLabel.addMouseListener(this.ml);
        this.layer2.add(this.msgKeyLabel);
        this.setCounterDisp();
        this.layer3 = new JPanel();
        this.layer3.setLayout(null);
        this.layer3.setBounds(0, 0, 536, 560);
        this.layer3.setOpaque(false);
        this.layer3.setBackground(Color.ORANGE);
        this.layer3.setFocusable(true);
        this.layer3.add(this.lblModeLeft);
        this.layer3.add(this.lblModeRight);
        this.layeredPane.add((Component)this.layer3, new Integer(3));
        JLabel lblQ = new JLabel("");
        lblQ.setOpaque(false);
        lblQ.setBackground(Color.YELLOW);
        lblQ.setHorizontalAlignment(0);
        lblQ.setBounds(111, 391, 23, 23);
        this.layer3.add(lblQ);
        lblQ.addMouseListener(new SoftMouse('Q'));
        JLabel lblW = new JLabel("");
        lblW.setOpaque(false);
        lblW.setBackground(Color.YELLOW);
        lblW.setHorizontalAlignment(0);
        lblW.setBounds(143, 391, 23, 23);
        this.layer3.add(lblW);
        lblW.addMouseListener(new SoftMouse('W'));
        JLabel lblE = new JLabel("");
        lblE.setOpaque(false);
        lblE.setBackground(Color.YELLOW);
        lblE.setHorizontalAlignment(0);
        lblE.setBounds(175, 391, 23, 23);
        this.layer3.add(lblE);
        lblE.addMouseListener(new SoftMouse('E'));
        JLabel lblR = new JLabel("");
        lblR.setOpaque(false);
        lblR.setBackground(Color.YELLOW);
        lblR.setHorizontalAlignment(0);
        lblR.setBounds(207, 391, 23, 23);
        this.layer3.add(lblR);
        lblR.addMouseListener(new SoftMouse('R'));
        JLabel lblT = new JLabel("");
        lblT.setOpaque(false);
        lblT.setBackground(Color.YELLOW);
        lblT.setHorizontalAlignment(0);
        lblT.setBounds(239, 391, 23, 23);
        this.layer3.add(lblT);
        lblT.addMouseListener(new SoftMouse('T'));
        JLabel lblY = new JLabel("");
        lblY.setOpaque(false);
        lblY.setBackground(Color.YELLOW);
        lblY.setHorizontalAlignment(0);
        lblY.setBounds(271, 391, 23, 23);
        this.layer3.add(lblY);
        lblY.addMouseListener(new SoftMouse('Y'));
        JLabel lblU = new JLabel("");
        lblU.setOpaque(false);
        lblU.setBackground(Color.YELLOW);
        lblU.setHorizontalAlignment(0);
        lblU.setBounds(303, 391, 23, 23);
        this.layer3.add(lblU);
        lblU.addMouseListener(new SoftMouse('U'));
        JLabel lblI = new JLabel("");
        lblI.setOpaque(false);
        lblI.setBackground(Color.YELLOW);
        lblI.setHorizontalAlignment(0);
        lblI.setBounds(335, 391, 23, 23);
        this.layer3.add(lblI);
        lblI.addMouseListener(new SoftMouse('I'));
        JLabel lblO = new JLabel("");
        lblO.setOpaque(false);
        lblO.setBackground(Color.YELLOW);
        lblO.setHorizontalAlignment(0);
        lblO.setBounds(367, 391, 23, 23);
        this.layer3.add(lblO);
        lblO.addMouseListener(new SoftMouse('O'));
        JLabel lblP = new JLabel("");
        lblP.setOpaque(false);
        lblP.setBackground(Color.YELLOW);
        lblP.setHorizontalAlignment(0);
        lblP.setBounds(399, 391, 23, 23);
        this.layer3.add(lblP);
        lblP.addMouseListener(new SoftMouse('P'));
        JLabel lblA = new JLabel("");
        lblA.setOpaque(false);
        lblA.setBackground(Color.YELLOW);
        lblA.setHorizontalAlignment(0);
        lblA.setBounds(117, 423, 23, 23);
        this.layer3.add(lblA);
        lblA.addMouseListener(new SoftMouse('A'));
        JLabel lblS = new JLabel("");
        lblS.setOpaque(false);
        lblS.setBackground(Color.YELLOW);
        lblS.setHorizontalAlignment(0);
        lblS.setBounds(149, 423, 23, 23);
        this.layer3.add(lblS);
        lblS.addMouseListener(new SoftMouse('S'));
        JLabel lblD = new JLabel("");
        lblD.setOpaque(false);
        lblD.setBackground(Color.YELLOW);
        lblD.setHorizontalAlignment(0);
        lblD.setBounds(181, 423, 23, 23);
        this.layer3.add(lblD);
        lblD.addMouseListener(new SoftMouse('D'));
        JLabel lblF = new JLabel("");
        lblF.setOpaque(false);
        lblF.setBackground(Color.YELLOW);
        lblF.setHorizontalAlignment(0);
        lblF.setBounds(213, 423, 23, 23);
        this.layer3.add(lblF);
        lblF.addMouseListener(new SoftMouse('F'));
        JLabel lblG = new JLabel("");
        lblG.setOpaque(false);
        lblG.setBackground(Color.YELLOW);
        lblG.setHorizontalAlignment(0);
        lblG.setBounds(245, 423, 23, 23);
        this.layer3.add(lblG);
        lblG.addMouseListener(new SoftMouse('G'));
        JLabel lblH = new JLabel("");
        lblH.setOpaque(false);
        lblH.setBackground(Color.YELLOW);
        lblH.setHorizontalAlignment(0);
        lblH.setBounds(277, 423, 23, 23);
        this.layer3.add(lblH);
        lblH.addMouseListener(new SoftMouse('H'));
        JLabel lblJ = new JLabel("");
        lblJ.setOpaque(false);
        lblJ.setBackground(Color.YELLOW);
        lblJ.setHorizontalAlignment(0);
        lblJ.setBounds(309, 423, 23, 23);
        this.layer3.add(lblJ);
        lblJ.addMouseListener(new SoftMouse('J'));
        JLabel lblK = new JLabel("");
        lblK.setOpaque(false);
        lblK.setBackground(Color.YELLOW);
        lblK.setHorizontalAlignment(0);
        lblK.setBounds(341, 423, 23, 23);
        this.layer3.add(lblK);
        lblK.addMouseListener(new SoftMouse('K'));
        JLabel lblL = new JLabel("");
        lblL.setOpaque(false);
        lblL.setBackground(Color.YELLOW);
        lblL.setHorizontalAlignment(0);
        lblL.setBounds(373, 423, 23, 23);
        this.layer3.add(lblL);
        lblL.addMouseListener(new SoftMouse('L'));
        JLabel lblRPT = new JLabel("");
        lblRPT.setOpaque(false);
        lblRPT.setBackground(Color.YELLOW);
        lblRPT.setHorizontalAlignment(0);
        lblRPT.setBounds(405, 423, 23, 23);
        lblRPT.addMouseListener(new SoftMouse('~'));
        this.layer3.add(lblRPT);
        JLabel lblZ = new JLabel("");
        lblZ.setOpaque(false);
        lblZ.setBackground(Color.YELLOW);
        lblZ.setHorizontalAlignment(0);
        lblZ.setBounds(133, 455, 23, 23);
        this.layer3.add(lblZ);
        lblZ.addMouseListener(new SoftMouse('Z'));
        JLabel lblX = new JLabel("");
        lblX.setOpaque(false);
        lblX.setBackground(Color.YELLOW);
        lblX.setHorizontalAlignment(0);
        lblX.setBounds(165, 455, 23, 23);
        this.layer3.add(lblX);
        lblX.addMouseListener(new SoftMouse('X'));
        JLabel lblC = new JLabel("");
        lblC.setOpaque(false);
        lblC.setBackground(Color.YELLOW);
        lblC.setHorizontalAlignment(0);
        lblC.setBounds(197, 455, 23, 23);
        this.layer3.add(lblC);
        lblC.addMouseListener(new SoftMouse('C'));
        JLabel lblV = new JLabel("");
        lblV.setOpaque(false);
        lblV.setBackground(Color.YELLOW);
        lblV.setHorizontalAlignment(0);
        lblV.setBounds(229, 455, 23, 23);
        this.layer3.add(lblV);
        lblV.addMouseListener(new SoftMouse('V'));
        JLabel lblB = new JLabel("");
        lblB.setOpaque(false);
        lblB.setBackground(Color.YELLOW);
        lblB.setHorizontalAlignment(0);
        lblB.setBounds(261, 455, 23, 23);
        this.layer3.add(lblB);
        lblB.addMouseListener(new SoftMouse('B'));
        JLabel lblN = new JLabel("");
        lblN.setOpaque(false);
        lblN.setBackground(Color.YELLOW);
        lblN.setHorizontalAlignment(0);
        lblN.setBounds(293, 455, 23, 23);
        this.layer3.add(lblN);
        lblN.addMouseListener(new SoftMouse('N'));
        JLabel lblM = new JLabel("");
        lblM.setOpaque(false);
        lblM.setBackground(Color.YELLOW);
        lblM.setHorizontalAlignment(0);
        lblM.setBounds(325, 455, 23, 23);
        this.layer3.add(lblM);
        lblM.addMouseListener(new SoftMouse('M'));
        JLabel lblLET = new JLabel("");
        lblLET.setOpaque(false);
        lblLET.setBackground(Color.YELLOW);
        lblLET.setHorizontalAlignment(0);
        lblLET.setBounds(357, 455, 23, 23);
        this.layer3.add(lblLET);
        lblLET.addMouseListener(new SoftMouse('}'));
        JLabel lblFIG = new JLabel("");
        lblFIG.setOpaque(false);
        lblFIG.setBackground(Color.YELLOW);
        lblFIG.setHorizontalAlignment(0);
        lblFIG.setBounds(389, 455, 23, 23);
        this.layer3.add(lblFIG);
        lblFIG.addMouseListener(new SoftMouse('{'));
        JLabel lblSpace = new JLabel("");
        lblSpace.setOpaque(false);
        lblSpace.setBackground(Color.YELLOW);
        lblSpace.setHorizontalAlignment(0);
        lblSpace.setBounds(145, 485, 255, 23);
        this.layer3.add(lblSpace);
        lblSpace.addMouseListener(new SoftMouse(' '));
        this.btnExit = new JButton("");
        this.btnExit.setToolTipText("Quit the Simulator");
        this.btnExit.setFont(new Font("Lucida Grande", 1, 9));
        this.btnExit.setIcon(new ImageIcon(this.getClass().getResource("/kl7-exit.png")));
        this.btnExit.setFocusable(false);
        this.btnExit.setContentAreaFilled(false);
        this.btnExit.setBounds(505, 0, 30, 24);
        this.btnExit.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.layer3.add(this.btnExit);
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.info = new Kl7Info();
        this.btnInfo = new JButton("");
        this.btnInfo.setToolTipText("About KL-7 Simulator");
        this.btnInfo.setIcon(new ImageIcon(this.getClass().getResource("/kl7-info.png")));
        this.btnInfo.setFocusable(false);
        this.btnInfo.setContentAreaFilled(false);
        this.btnInfo.setBounds(467, 1, 45, 24);
        this.btnInfo.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.layer3.add(this.btnInfo);
        this.btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KL7Sim.this.info.setVisible(true);
            }
        });
        this.btnHelp = new JButton("");
        this.btnHelp.setToolTipText("Help file");
        this.btnHelp.setIcon(new ImageIcon(this.getClass().getResource("/kl7-help.png")));
        this.btnHelp.setFocusable(false);
        this.btnHelp.setContentAreaFilled(false);
        this.btnHelp.setBounds(442, 0, 33, 24);
        this.btnHelp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.layer3.add(this.btnHelp);
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KL7Sim.this.presentMouseFile();
            }
        });
        final ImageIcon sndOn = new ImageIcon(this.getClass().getResource("/kl7-soundON.png"));
        final ImageIcon sndOff = new ImageIcon(this.getClass().getResource("/kl7-soundOFF.png"));
        this.btnSoundToggle = new JButton("");
        this.btnSoundToggle.setToolTipText("Click to turn the sound OFF");
        this.btnSoundToggle.setIcon(sndOn);
        this.btnSoundToggle.setFocusable(false);
        this.btnSoundToggle.setContentAreaFilled(false);
        this.btnSoundToggle.setBounds(408, 0, 46, 24);
        this.btnSoundToggle.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.layer3.add(this.btnSoundToggle);
        this.btnSoundToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KL7Sim.this.playSound) {
                    KL7Sim.this.playSound = false;
                    KL7Sim.this.btnSoundToggle.setBounds(407, 1, 46, 24);
                    KL7Sim.this.btnSoundToggle.setIcon(sndOff);
                    KL7Sim.this.btnSoundToggle.setToolTipText("Click to turn the sound ON");
                    KL7Sim.this.soundRun.stop();
                    KL7Sim.this.soundRun.setMicrosecondPosition(0L);
                } else {
                    KL7Sim.this.playSound = true;
                    KL7Sim.this.btnSoundToggle.setBounds(407, 0, 46, 24);
                    KL7Sim.this.btnSoundToggle.setIcon(sndOn);
                    KL7Sim.this.btnSoundToggle.setToolTipText("Click to turn the sound OFF");
                    KL7Sim.this.soundRun.setMicrosecondPosition(0L);
                    if (KL7Sim.this.rbox.getBoxMode() != BoxMode.O) {
                        KL7Sim.this.soundRun.setMicrosecondPosition(0L);
                        KL7Sim.this.soundRun.loop(-1);
                    }
                }
                KL7Sim.this.repaint();
            }
        });
        JButton btnCodebook = new JButton("Codebook");
        btnCodebook.setBounds(11, 0, 84, 22);
        btnCodebook.setFont(new Font("Lucida Grande", 1, 9));
        btnCodebook.setToolTipText("Click to start Codebook generator (generates keys)");
        this.layer3.add(btnCodebook);
        btnCodebook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KL7Sim.this.codeBook.enableBook();
                KL7Sim.this.codeBook.setVisible(true);
            }
        });
        JButton btnRewire = new JButton("Rewire");
        btnRewire.setBounds(102, 0, 70, 22);
        btnRewire.setFont(new Font("Lucida Grande", 1, 9));
        btnRewire.setToolTipText("Click to start Customizer (generates new wiring for rotors, etc)");
        this.layer3.add(btnRewire);
        btnRewire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KL7Sim.this.reWire.setVisible(true);
            }
        });
        this.layer3.setEnabled(true);
        if (!this.setSound()) {
            this.playSound = false;
            this.btnSoundToggle.setBounds(407, 1, 46, 24);
            this.btnSoundToggle.setIcon(sndOff);
            this.btnSoundToggle.setEnabled(false);
        }
        this.layer4 = new JPanel();
        this.layer4.setBounds(0, 0, 550, 597);
        this.layer4.setFocusable(true);
        this.layer4.setOpaque(false);
        this.layer4.setVisible(true);
        this.layeredPane.add((Component)this.layer4, new Integer(4));
        this.layer4.addKeyListener(this.kin);
        this.repaint();
        this.reqFoc();
    }

    boolean setSound() {
        try {
            this.aisSndStart = AudioSystem.getAudioInputStream(this.getClass().getResource("/soundstart.wav"));
            this.aisSndStop = AudioSystem.getAudioInputStream(this.getClass().getResource("/soundstop.wav"));
            this.aisSndRun = AudioSystem.getAudioInputStream(this.getClass().getResource("/soundrun.wav"));
            this.aisSndPlain = AudioSystem.getAudioInputStream(this.getClass().getResource("/soundplain.wav"));
            this.aisSndCipher = AudioSystem.getAudioInputStream(this.getClass().getResource("/soundcipher.wav"));
            this.audioFormat = this.aisSndStart.getFormat();
        }
        catch (UnsupportedAudioFileException ex1) {
            JOptionPane.showMessageDialog(this.rootPane, "Could not import audio file into AudioInputStream! Unsupported audio file. " + ex1.getMessage(), "Cannot create audioInputStream", 0);
            ex1.printStackTrace();
            return false;
        }
        catch (IOException ex2) {
            JOptionPane.showMessageDialog(this.rootPane, "Could not import audio file into AudioInputStream! IOException " + ex2.getMessage(), "Cannot create audioInputStream", 0);
            ex2.printStackTrace();
            return false;
        }
        try {
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.audioFormat = this.aisSndStart.getFormat();
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.soundStart = (Clip)AudioSystem.getLine(this.infoSnd);
            this.soundStart.open(this.aisSndStart);
            this.audioFormat = this.aisSndStop.getFormat();
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.soundStop = (Clip)AudioSystem.getLine(this.infoSnd);
            this.soundStop.open(this.aisSndStop);
            this.audioFormat = this.aisSndRun.getFormat();
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.soundRun = (Clip)AudioSystem.getLine(this.infoSnd);
            this.soundRun.open(this.aisSndRun);
            this.audioFormat = this.aisSndPlain.getFormat();
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.soundPlain = (Clip)AudioSystem.getLine(this.infoSnd);
            this.soundPlain.open(this.aisSndPlain);
            this.audioFormat = this.aisSndCipher.getFormat();
            this.infoSnd = new DataLine.Info(Clip.class, this.audioFormat);
            this.soundCipher = (Clip)AudioSystem.getLine(this.infoSnd);
            this.soundCipher.open(this.aisSndCipher);
            return true;
        }
        catch (IOException ex4) {
            JOptionPane.showMessageDialog(this.rootPane, "Could not get Clip! IO error. " + ex4.getMessage(), "Cannot create audio Clip", 0);
            ex4.printStackTrace(System.err);
            return false;
        }
        catch (LineUnavailableException ex3) {
            JOptionPane.showMessageDialog(this.rootPane, "Could not get Clip! Line unavailable. " + ex3.getMessage(), "Cannot create audio Clip", 0);
            ex3.printStackTrace(System.err);
            return false;
        }
        catch (IllegalArgumentException ex3) {
            JOptionPane.showMessageDialog(this.rootPane, "Could not get audio line! IllegalArgumentException " + ex3.getMessage(), "Cannot create audio DataLine", 0);
            ex3.printStackTrace();
            return false;
        }
    }

    void reqFoc() {
        this.requestFocus();
        this.setFocusable(true);
        this.setFocusableWindowState(true);
        this.removeKeyListener(this.kin);
        this.addKeyListener(this.kin);
    }

    String getKeyTitle() {
        return this.keyTitle;
    }

    public void setKeyTitle(String s) {
        if (s != null) {
            this.keyTitle = s;
        }
    }

    void printChar(char ch) {
        int l = 0;
        int m = 0;
        this.outputText = this.outputTape.getText();
        if (!Character.isLetterOrDigit(ch = Character.toUpperCase(ch)) && !Character.isWhitespace(ch)) {
            return;
        }
        this.fullOutputText = this.fullOutputText == null ? (this.outputText == null ? Character.toString(ch) : String.valueOf(this.outputText) + Character.toString(ch)) : String.valueOf(this.fullOutputText) + ch;
        this.outputText = this.outputText == null || this.outputText.length() == 0 || this.outputText.charAt(0) == '\u0000' ? String.valueOf(ch) : String.valueOf(this.outputText) + String.valueOf(ch);
        m = this.outputText.length();
        l = m < 52 ? 0 : m - 52;
        this.outputTape.setText(this.outputText.substring(l));
    }

    void plainChar(char ch) {
        if ((ch = Character.toUpperCase(ch)) == '{') {
            this.rbox.setReg(Register.FIG);
        } else if (ch == '}') {
            this.rbox.setReg(Register.LET);
        }
        if (Character.isLetter(ch) && this.bReg == Register.FIG || Character.isDigit(ch) && this.bReg == Register.LET) {
            return;
        }
        if (ch != '{' && ch != '}' && ch != '~') {
            block11: {
                if (this.playSound) {
                    this.soundPlain.start();
                    try {
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.soundPlain.stop();
                            this.soundPlain.setMicrosecondPosition(0L);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        this.soundPlain.stop();
                        this.soundPlain.setMicrosecondPosition(0L);
                        throw throwable;
                    }
                    this.soundPlain.stop();
                    this.soundPlain.setMicrosecondPosition(0L);
                }
            }
            this.printChar(ch);
        }
        this.setRegLamp();
    }

    void encryptChar(char ch) {
        this.bReg = this.rbox.getReg();
        this.bM = this.rbox.getBoxMode();
        if (this.bM != BoxMode.E) {
            System.out.println("PROBLEM! Machine is not set to encrypt!");
            return;
        }
        if (!Character.isLetterOrDigit(ch = Character.toUpperCase(ch)) && !Character.isWhitespace(ch) && ch != '{' && ch != '}') {
            return;
        }
        String in = "";
        if (Character.isLetter(ch) && this.bReg == Register.FIG ? !this.autoRun : Character.isDigit(ch) && this.bReg == Register.LET && !this.autoRun) {
            return;
        }
        in = String.valueOf(ch);
        String out = this.rbox.encryptString(in);
        this.setCounterDisp();
        int i = 0;
        while (i < out.length()) {
            block12: {
                if (this.addSpace) {
                    this.addSpace = false;
                    this.printChar(' ');
                }
                this.printChar(out.charAt(i));
                if (this.playSound) {
                    this.soundCipher.start();
                    try {
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.soundCipher.stop();
                            this.soundCipher.setMicrosecondPosition(0L);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        this.soundCipher.stop();
                        this.soundCipher.setMicrosecondPosition(0L);
                        throw throwable;
                    }
                    this.soundCipher.stop();
                    this.soundCipher.setMicrosecondPosition(0L);
                }
            }
            if (++this.encCounter == 5) {
                this.encCounter = 0;
                this.addSpace = true;
            }
            ++i;
        }
        this.setRegLamp();
        this.repaintWin();
    }

    void decryptChar(char ch) {
        if (this.rbox.getBoxMode() != BoxMode.D) {
            System.out.println("PROBLEM! Machine is not set to decrypt!");
            return;
        }
        if (!Character.isLetter(ch)) {
            return;
        }
        String in = String.valueOf(ch);
        String out = this.rbox.decryptString(in);
        this.setCounterDisp();
        int i = 0;
        while (i < out.length()) {
            block9: {
                this.printChar(out.charAt(i));
                if (this.playSound) {
                    this.soundCipher.start();
                    try {
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.soundCipher.stop();
                            this.soundCipher.setMicrosecondPosition(0L);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.soundCipher.stop();
                        this.soundCipher.setMicrosecondPosition(0L);
                        throw throwable;
                    }
                    this.soundCipher.stop();
                    this.soundCipher.setMicrosecondPosition(0L);
                }
            }
            ++i;
        }
        this.setRegLamp();
        this.repaintWin();
    }

    public void setAutoRun(boolean t) {
        this.autoRun = t;
    }

    public boolean getAutoRun() {
        return this.autoRun;
    }

    public void setRegLamp() {
        this.bReg = this.rbox.getReg();
        if (this.bReg == Register.FIG) {
            this.FIG_lamp.setVisible(true);
            this.LET_lamp.setVisible(false);
        } else {
            this.FIG_lamp.setVisible(false);
            this.LET_lamp.setVisible(true);
        }
    }

    public void setCounterDisp() {
        int i = this.rbox.getCounter();
        String formatted = String.format("%04d", i);
        this.counterDisp.setText(formatted);
        this.counterDisp.setVisible(true);
    }

    private String createWinString(char[] inp) {
        StringBuffer sb = new StringBuffer(new String(inp));
        sb.insert(2, '\n');
        sb.insert(1, '\n');
        return sb.toString();
    }

    public void repaintWin() {
        int i = 0;
        while (i < 8) {
            if (i != 3) {
                String s = this.createWinString(this.rbox.getRotorFullWin(i));
                if (s == null) {
                    System.err.println("repaintWin(): HUGE PROBLEM! getRotorFullWin(" + i + ") returned null");
                    System.err.println("\tRotor: " + this.rbox.getRotor(i));
                    System.exit(-5);
                }
                this.rwin[i].setText(s);
            }
            ++i;
        }
        this.repaint();
    }

    char letToDigSubst(char in) {
        int i = "QWERTYUIOP".indexOf(in);
        if (i != -1) {
            return "1234567890".charAt(i);
        }
        return '\u00ff';
    }

    char digToLetSubst(char in) {
        int i = "1234567890".indexOf(in);
        if (i != -1) {
            return "QWERTYUIOP".charAt(i);
        }
        return '\u00ff';
    }

    public String getOutputText() {
        return this.fullOutputText;
    }

    public void addOutputText(String s) {
        String ss = this.outputTape.getText();
        this.fullOutputText = this.fullOutputText == null ? s : String.valueOf(this.fullOutputText) + s;
        ss = String.valueOf(ss) + s;
        int i = ss.length() < 52 ? 0 : ss.length() - 52;
        this.outputTape.setText(ss.substring(i));
        i = s.length() - 1;
        char ch = s.charAt(i);
        while (ch == ' ' && i > 0) {
            ch = s.charAt(--i);
        }
        if (Character.isDigit(ch)) {
            this.rbox.setReg(Register.FIG);
        } else {
            this.rbox.setReg(Register.LET);
        }
        this.setRegLamp();
        this.repaintWin();
        this.setCounterDisp();
    }

    void clearOutputTape() {
        this.outputTape.setText("");
        this.outputText = null;
        this.fullOutputText = null;
    }

    void moveModeLeft() {
        BoxMode md = this.rbox.getBoxMode();
        this.lblModeRight.setVisible(true);
        this.encCounter = 0;
        if (md == BoxMode.D) {
            this.rbox.setBoxMode(BoxMode.E);
            this.lblMode.setIcon(this.modeE);
            this.lblModeRight.setToolTipText("Click here to switch machine to Decrypt mode");
            this.lblModeLeft.setToolTipText("Click here to switch machine to Plaintext mode");
        } else if (md == BoxMode.E) {
            this.rbox.setBoxMode(BoxMode.P);
            this.repaintWin();
            this.setCounterDisp();
            this.printChar(' ');
            this.encCounter = 0;
            this.lblMode.setIcon(this.modeP);
            this.lblModeRight.setToolTipText("Click here to switch machine to Encrypt mode");
            this.lblModeLeft.setToolTipText("Click here to switch machine OFF");
            if (this.playSound) {
                this.soundPlain.start();
                try {
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.soundPlain.stop();
                        this.soundPlain.setMicrosecondPosition(0L);
                    }
                }
                finally {
                    this.soundPlain.stop();
                    this.soundPlain.setMicrosecondPosition(0L);
                }
            }
        } else if (md == BoxMode.P) {
            block17: {
                this.lblMode.setIcon(this.modeO);
                this.rbox.setBoxMode(BoxMode.O);
                this.rbox.setReg(Register.LET);
                this.setRegLamp();
                this.repaint();
                if (this.playSound) {
                    this.soundRun.stop();
                    this.soundStop.start();
                    try {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.soundStop.stop();
                            this.soundStop.setMicrosecondPosition(0L);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.soundStop.stop();
                        this.soundStop.setMicrosecondPosition(0L);
                        throw throwable;
                    }
                    this.soundStop.stop();
                    this.soundStop.setMicrosecondPosition(0L);
                }
            }
            this.lblModeRight.setToolTipText("Click here to turn machine ON (in Plaintext mode)");
            this.lblModeLeft.setVisible(false);
            this.lblModeLeft.setToolTipText("");
        }
    }

    void moveModeRight() {
        BoxMode md = this.rbox.getBoxMode();
        this.lblModeLeft.setVisible(true);
        this.encCounter = 0;
        if (md == BoxMode.O) {
            this.rbox.setBoxMode(BoxMode.P);
            this.lblMode.setIcon(this.modeP);
            this.repaint();
            this.lblModeRight.setVisible(true);
            this.lblModeRight.setToolTipText("Click here to switch machine to Encrypt mode");
            this.lblModeLeft.setToolTipText("Click here to turn machine OFF");
            if (this.playSound) {
                this.soundStart.start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.soundStart.stop();
                this.soundStart.setMicrosecondPosition(0L);
                this.soundRun.setMicrosecondPosition(0L);
                this.soundRun.loop(-1);
            }
        } else if (md == BoxMode.P) {
            this.rbox.setBoxMode(BoxMode.E);
            if (this.playSound) {
                this.soundPlain.start();
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.soundPlain.stop();
                this.soundPlain.setMicrosecondPosition(0L);
            }
            this.printChar(' ');
            this.lblMode.setIcon(this.modeE);
            this.lblModeRight.setToolTipText("Click here to switch machine to Decrypt mode");
            this.lblModeLeft.setToolTipText("Click here to switch machine to Plaintext mode");
            this.repaintWin();
            this.setCounterDisp();
            this.encCounter = 0;
        } else if (md == BoxMode.E) {
            this.rbox.setBoxMode(BoxMode.D);
            this.encCounter = 0;
            this.lblMode.setIcon(this.modeD);
            this.lblModeRight.setToolTipText("");
            this.lblModeRight.setVisible(false);
            this.lblModeLeft.setToolTipText("Click here to switch machine to Encrypt mode");
        }
    }

    public void outDropFocus() {
        this.outputTape.setFocusable(false);
    }

    public BoxMode getBoxMode() {
        return this.rbox.getBoxMode();
    }

    void dispBoxMode() {
        switch (this.rbox.getBoxMode()) {
            case O: {
                this.lblMode.setIcon(this.modeO);
                break;
            }
            case P: {
                this.lblMode.setIcon(this.modeP);
                break;
            }
            case E: {
                this.lblMode.setIcon(this.modeE);
                break;
            }
            case D: {
                this.lblMode.setIcon(this.modeD);
                break;
            }
        }
        this.lblMode.setVisible(true);
    }

    void dispBoxRegister() {
        if (this.rbox.getReg() == Register.FIG) {
            this.FIG_lamp.setVisible(true);
        } else {
            this.FIG_lamp.setVisible(false);
        }
    }

    public void adjustTitle(String s) {
        this.title = this.mainTitle;
        if (this.custTitle != null) {
            this.title = String.valueOf(this.title) + "  " + this.custTitle;
        }
        if (s != null) {
            this.title = String.valueOf(this.title) + "  (" + s + ")";
        }
        this.setTitle(this.title);
    }

    void saveStateToFile() {
        File saveTo = new File("kl7-savedstate.dat");
        FileOutputStream fos = null;
        ObjectOutputStream jos = null;
        try {
            if (!saveTo.canWrite() && !saveTo.createNewFile()) {
                JOptionPane.showMessageDialog(null, "Cannot save Box state to file \"" + saveTo.getName() + "\"", "Cannot write to file", 0);
                return;
            }
            try {
                fos = new FileOutputStream(saveTo);
                jos = new ObjectOutputStream(fos);
                jos.writeObject(this.rbox);
                jos.close();
                JOptionPane.showMessageDialog(this.rootPane, "Saved machine state and keying in file " + saveTo.getName(), "Successfully saved state", -1);
            }
            catch (IOException exep) {
                JOptionPane.showMessageDialog(this.rootPane, "Cannot save Box state and contents " + exep.getMessage(), "Saving state failed", 0);
            }
        }
        finally {
            try {
                if (jos != null) {
                    jos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException exep2) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    void restoreStateFromFile() {
        File readFrom = new File("kl7-savedstate.dat");
        if (!(readFrom.exists() && readFrom.isFile() && readFrom.canRead())) {
            JOptionPane.showMessageDialog(null, "Cannot open saved Box state (file \"" + readFrom.getName() + "\"", "Cannot read from file", 0);
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream jis = null;
        try {
            try {
                fis = new FileInputStream(readFrom);
                jis = new ObjectInputStream(fis);
                this.rbox = (Box)jis.readObject();
                jis.close();
                this.dispBoxMode();
                this.dispBoxRegister();
                this.mkset.setNewBox(this.rbox);
                this.kat.setNewBox(this.rbox);
                this.box.setNewBox(this.rbox);
                this.codeBook.setNewBox(this.rbox);
                JOptionPane.showMessageDialog(this.rootPane, "Restored machine state and keying from file " + readFrom.getName(), "Successfully restored state", -1);
            }
            catch (ClassNotFoundException exep) {
                JOptionPane.showMessageDialog(this.rootPane, "Cannot restore Box state and contents: class not found " + exep.getMessage(), "Reading saving state failed", 0);
                try {
                    if (jis != null) {
                        jis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException exep2) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException exep1) {
                JOptionPane.showMessageDialog(this.rootPane, "Cannot restore Box state and contents: IO problem " + exep1.getMessage(), "Reading saving state failed", 0);
                try {
                    if (jis != null) {
                        jis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException exep2) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            try {
                if (jis != null) {
                    jis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException exep2) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean getAbort() {
        return this.abortRun;
    }

    public void setAbort(boolean t) {
        this.abortRun = t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCustomization(File inf) {
        FileReader fir = null;
        BufferedReader bir = null;
        boolean retcode = true;
        try {
            fir = new FileReader(inf);
            bir = new BufferedReader(fir);
            String s = bir.readLine();
            if (s == null) {
                return false;
            }
            do {
                char ch = s.charAt(0);
                if (s.matches("^T=.+")) {
                    this.addTitle(s);
                    s = bir.readLine();
                    continue;
                }
                if (!s.matches("^((([A-MP]=)([A-Z0-9]{36}))|(([01][0-9]=)([01]{36})))")) {
                    JOptionPane.showMessageDialog(null, "Malformed record in the customization file " + inf.getName() + "\n\"" + s + "\"", "CUSTOMIZATION FAILED", 0);
                    return false;
                }
                switch (ch) {
                    case '0': 
                    case '1': {
                        boolean ret = this.addCustomNotchedRing(s);
                        if (!retcode) break;
                        retcode = ret;
                        break;
                    }
                    case 'P': {
                        boolean ret = this.addCustomPlate(s);
                        if (!retcode) break;
                        retcode = ret;
                        break;
                    }
                    default: {
                        boolean ret = this.addCustomRotor(s);
                        if (!retcode) break;
                        retcode = ret;
                    }
                }
                s = bir.readLine();
            } while (s != null);
            bir.close();
            this.rbox.reconfigureCage();
            this.bReg = this.rbox.getReg();
            this.bM = this.rbox.getBoxMode();
            boolean bl = retcode;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            retcode = false;
            return retcode;
        }
        finally {
            try {
                if (bir != null) {
                    bir.close();
                }
                if (fir != null) {
                    fir.close();
                }
            }
            catch (IOException exex) {
                try {
                    if (fir != null) {
                        fir.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    void addTitle(String s) {
        String ss = s.substring(0, 2);
        if (!ss.equals("T=")) {
            return;
        }
        ss = s.substring(2);
        if (ss.indexOf("=") != -1) {
            return;
        }
        this.custTitle = ss;
        this.title = String.valueOf(this.mainTitle) + "  " + this.custTitle;
        this.setTitle(this.title);
        this.repaint();
    }

    boolean addCustomPlate(String s) {
        if (!s.startsWith("P=")) {
            return false;
        }
        return this.rbox.setCustomBasePlate(s.substring(2));
    }

    boolean addCustomRotor(String s) {
        int i = s.indexOf(61);
        if (i != 1 || s.substring(2).indexOf("=") != -1) {
            return false;
        }
        return this.rbox.setCustomRotor(s.substring(0, 1), s.substring(2));
    }

    boolean addCustomNotchedRing(String s) {
        int i = s.indexOf(61);
        if (i != 2) {
            return false;
        }
        int ring = Integer.parseInt(s.substring(0, 2));
        return this.rbox.setCustomNRing(ring, s.substring(3));
    }

    void presentHelpFile() {
        try {
            if (Desktop.isDesktopSupported()) {
                this.displayPDFFile("/KL-7_Help.pdf");
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "AWT Desktop not supported - cannot display PDF file \"KL-7_Help.pd\"!", "Desktop not supported", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.rootPane, "Problem trying to open and display file \"\": " + ex.getMessage(), "Exception trying to open Help file", 0);
        }
    }

    void presentMouseFile() {
        try {
            if (Desktop.isDesktopSupported()) {
                this.displayPDFFile("/KL-About.pdf");
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "AWT Desktop not supported - cannot display PDF file \"KL-About.pdf\"!", "Desktop not supported", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.rootPane, "Problem trying to open and display file \"\": " + ex.getMessage(), "Exception trying to open Help file", 0);
        }
    }

    void displayPDFFile(String name) throws IOException {
        File f = null;
        OutputStream o = null;
        byte[] buf = new byte[2048];
        int len = 0;
        InputStream fis = this.getClass().getResourceAsStream(name);
        try {
            try {
                f = File.createTempFile(name, ".pdf");
                f.deleteOnExit();
                o = new FileOutputStream(f);
                try {
                    while ((len = fis.read(buf)) >= 0) {
                        o.write(buf, 0, len);
                    }
                    o.close();
                }
                catch (IOException iex3) {
                    System.err.println("Exception copying PDF file " + name);
                    iex3.printStackTrace();
                    o.close();
                    fis.close();
                    f.delete();
                }
                Desktop.getDesktop().open(f);
            }
            catch (IOException iex) {
                System.err.println("Exception dealing with PDF file " + name);
                iex.printStackTrace();
                if (o != null) {
                    o.close();
                }
                fis.close();
                if (f != null) {
                    f.delete();
                }
                try {
                    if (o != null) {
                        o.close();
                    }
                    fis.close();
                }
                catch (IOException iex1) {
                    System.err.println("Exception displaying PDF file " + name);
                    iex1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (o != null) {
                    o.close();
                }
                fis.close();
            }
            catch (IOException iex1) {
                System.err.println("Exception displaying PDF file " + name);
                iex1.printStackTrace();
            }
        }
    }

    private class KeyboardInput
    implements KeyListener {
        private boolean repeatStroke = false;

        private KeyboardInput() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char ch = e.getKeyChar();
            KL7Sim.this.bM = KL7Sim.this.rbox.getBoxMode();
            KL7Sim.this.bReg = KL7Sim.this.rbox.getReg();
            if (ch == '\u007f' || ch == '\b') {
                KL7Sim.this.outputTape.setText("");
                KL7Sim.this.outputText = null;
                KL7Sim.this.fullOutputText = null;
                KL7Sim.this.encCounter = 0;
                return;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KL7Sim.this.bReg = KL7Sim.this.rbox.getReg();
            KL7Sim.this.bM = KL7Sim.this.rbox.getBoxMode();
            int kcode = e.getKeyCode();
            char ch = e.getKeyChar();
            if (KL7Sim.this.bM == BoxMode.O && kcode != 37 && kcode != 39 && kcode != 112 && kcode != 113 && kcode != 114 && kcode != 118 && kcode != 119 && kcode != 120) {
                return;
            }
            if (Character.isLetterOrDigit(ch) || Character.isWhitespace(ch)) {
                this.repeatStroke = false;
                if (KL7Sim.this.tRpt != null) {
                    KL7Sim.this.tRpt.interrupt();
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (KL7Sim.this.enableRPT) {
                    this.repeatStroke = true;
                    KL7Sim.this.tRpt = new Thread(new CharThread(ch));
                    KL7Sim.this.tRpt.start();
                } else {
                    this.processChar(ch);
                }
                return;
            }
            if (e.isActionKey()) {
                this.processActionKey(kcode);
            } else if (e.isShiftDown()) {
                if (KL7Sim.this.bReg == Register.LET) {
                    if (KL7Sim.this.bM != BoxMode.O && KL7Sim.this.bM != BoxMode.D) {
                        KL7Sim.this.rbox.setReg(Register.FIG);
                    }
                    if (KL7Sim.this.bM == BoxMode.E) {
                        KL7Sim.this.encryptChar('{');
                    }
                } else {
                    if (KL7Sim.this.bM != BoxMode.O && KL7Sim.this.bM != BoxMode.D) {
                        KL7Sim.this.rbox.setReg(Register.LET);
                    }
                    if (KL7Sim.this.bM == BoxMode.E) {
                        KL7Sim.this.encryptChar('}');
                    }
                }
            }
            if (kcode == 155 || kcode == 10 && e.isControlDown()) {
                KL7Sim.this.saveStateToFile();
                return;
            }
            if (kcode == 27) {
                KL7Sim.this.abortRun = true;
            }
            KL7Sim.this.setRegLamp();
            KL7Sim.this.repaintWin();
            KL7Sim.this.setCounterDisp();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (KL7Sim.this.tRpt != null) {
                KL7Sim.this.tRpt.interrupt();
            }
            this.repeatStroke = false;
        }

        private void processActionKey(int kcode) {
            switch (kcode) {
                case 37: {
                    KL7Sim.this.moveModeLeft();
                    KL7Sim.this.encCounter = 0;
                    break;
                }
                case 39: {
                    KL7Sim.this.moveModeRight();
                    break;
                }
                case 38: {
                    if (KL7Sim.this.bM != BoxMode.O && KL7Sim.this.bM != BoxMode.D) {
                        KL7Sim.this.rbox.setReg(Register.FIG);
                    }
                    if (KL7Sim.this.bM != BoxMode.E) break;
                    KL7Sim.this.encryptChar('{');
                    break;
                }
                case 40: {
                    if (KL7Sim.this.bM != BoxMode.O && KL7Sim.this.bM != BoxMode.D) {
                        KL7Sim.this.rbox.setReg(Register.LET);
                    }
                    if (KL7Sim.this.bM != BoxMode.E) break;
                    KL7Sim.this.encryptChar('}');
                    break;
                }
                case 36: {
                    KL7Sim.this.restoreStateFromFile();
                    break;
                }
                case 35: {
                    KL7Sim.this.saveStateToFile();
                    break;
                }
                case 112: {
                    KL7Sim.this.presentMouseFile();
                    break;
                }
                case 113: {
                    KL7Sim.this.presentHelpFile();
                    break;
                }
                case 114: {
                    KL7Sim.this.enableRPT = !KL7Sim.this.enableRPT;
                    String str = KL7Sim.this.enableRPT ? "enabled." : "disabled.";
                    JOptionPane.showMessageDialog(null, "RPT functionality now " + str, "RPT functionality", -1);
                    break;
                }
                case 115: {
                    KL7Sim.this.rbox.resetCounter();
                    KL7Sim.this.setCounterDisp();
                    break;
                }
                case 116: {
                    KL7Sim.this.klp.setVisible(true);
                    break;
                }
                case 117: {
                    KL7Sim.this.kat.setVisible(true);
                    break;
                }
                case 118: {
                    JFileChooser fchooser = new JFileChooser();
                    int returnVal = fchooser.showOpenDialog(KL7Sim.this);
                    if (returnVal == 0) {
                        File file = fchooser.getSelectedFile();
                        SavedState sst = new SavedState(KL7Sim.this.rbox);
                        sst.saveState();
                        String ssTitle = KL7Sim.this.keyTitle;
                        if (KL7Sim.this.doCustomization(file)) {
                            sst.restoreState();
                            KL7Sim.this.box.setNewBox(KL7Sim.this.rbox);
                            KL7Sim.this.kat.setNewBox(KL7Sim.this.rbox);
                            KL7Sim.this.mkset.setNewBox(KL7Sim.this.rbox);
                            KL7Sim.this.codeBook.setNewBox(KL7Sim.this.rbox);
                            KL7Sim.this.customized = true;
                            KL7Sim.this.adjustTitle(ssTitle);
                            JOptionPane.showMessageDialog(KL7Sim.this.rootPane, "Customization file " + file.getName() + " loaded successfully.", "CUSTOMIZATION SUCCEEDED", -1);
                            break;
                        }
                        JOptionPane.showMessageDialog(KL7Sim.this.rootPane, "Customization file " + file.getName() + " did not load successfully!\n" + "Complete or partial failure caused by malformed" + " records in the file.", "CUSTOMIZATION FAILED", 0);
                        break;
                    }
                    JOptionPane.showMessageDialog(KL7Sim.this.rootPane, "Customization request cancelled ", "Customization cancelled", 2);
                    break;
                }
                case 119: {
                    SavedState sst = new SavedState(KL7Sim.this.rbox);
                    sst.saveState();
                    KL7Sim.this.rbox = new Box();
                    sst.changeBox(KL7Sim.this.rbox);
                    sst.restoreState();
                    KL7Sim.this.customized = false;
                    KL7Sim.this.box.setNewBox(KL7Sim.this.rbox);
                    KL7Sim.this.kat.setNewBox(KL7Sim.this.rbox);
                    KL7Sim.this.mkset.setNewBox(KL7Sim.this.rbox);
                    KL7Sim.this.codeBook.setNewBox(KL7Sim.this.rbox);
                    KL7Sim.this.custTitle = null;
                    KL7Sim.this.setTitle(KL7Sim.this.mainTitle);
                    if (KL7Sim.this.keyTitle != null) {
                        KL7Sim.this.adjustTitle(KL7Sim.this.keyTitle);
                    }
                    JOptionPane.showMessageDialog(KL7Sim.this.rootPane, "Customization removed successfully. Machine is returned to complete compatibility with Dirk Rijmenants' version.", "CUSTOMIZATION REMOVED", -1);
                    break;
                }
                case 120: {
                    KL7Sim.this.box.setVisible(true);
                    break;
                }
            }
        }

        private void processChar(char ch) {
            if (Character.isLetter(ch)) {
                ch = Character.toUpperCase(ch);
            }
            if (Character.isLetterOrDigit(ch) || Character.isWhitespace(ch)) {
                if (Character.isDigit(ch) && KL7Sim.this.bReg == Register.LET) {
                    return;
                }
                if (Character.isLetter(ch) && KL7Sim.this.bReg == Register.FIG && KL7Sim.this.bM != BoxMode.D) {
                    return;
                }
                switch (KL7Sim.this.bM) {
                    case O: {
                        return;
                    }
                    case P: {
                        if (KL7Sim.this.bReg == Register.FIG && "QWERTYUIOP".indexOf(ch) != -1) {
                            ch = KL7Sim.this.letToDigSubst(ch);
                        }
                        KL7Sim.this.plainChar(ch);
                        break;
                    }
                    case E: {
                        KL7Sim.this.encryptChar(ch);
                        break;
                    }
                    case D: {
                        if (!Character.isLetter(ch)) {
                            return;
                        }
                        KL7Sim.this.decryptChar(ch);
                        break;
                    }
                    default: {
                        System.err.println("Got a WEIRD Box mode: " + (Object)((Object)KL7Sim.this.rbox.getBoxMode()));
                    }
                }
                KL7Sim.this.setRegLamp();
                KL7Sim.this.repaintWin();
                return;
            }
        }

        class CharThread
        implements Runnable {
            char ch;

            public CharThread(char c) {
                this.ch = c;
            }

            @Override
            public void run() {
                this.runChar();
            }

            public void runChar() {
                do {
                    if (KeyboardInput.this.repeatStroke) {
                        KeyboardInput.this.processChar(this.ch);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        KeyboardInput.this.repeatStroke = false;
                        break;
                    }
                } while (KeyboardInput.this.repeatStroke);
            }

            public void stop() {
                KeyboardInput.this.repeatStroke = false;
            }
        }
    }

    class MListen
    implements MouseListener {
        private K4Panel b;
        private MsgKeySet mset;
        private Kl7AutoType kat;

        MListen(K4Panel b, MsgKeySet ms, Kl7AutoType kat) {
            this.b = b;
            this.mset = ms;
            this.kat = kat;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == KL7Sim.this.panelPopupLabel) {
                this.b.setVisible(true);
                KL7Sim.this.repaintWin();
            } else if (e.getSource() == KL7Sim.this.msgKeyLabel) {
                if (KL7Sim.this.rbox.getBoxMode() != BoxMode.O) {
                    this.mset.setVisible(true);
                }
                KL7Sim.this.repaintWin();
            } else if (e.getSource() == KL7Sim.this.cntReset) {
                KL7Sim.this.rbox.resetCounter();
                KL7Sim.this.setCounterDisp();
            } else if (e.getSource() == KL7Sim.this.clipBoardLabel) {
                KL7Sim.this.abortRun = false;
                if (KL7Sim.this.rbox.getBoxMode() != BoxMode.O) {
                    this.kat.setVisible(true);
                }
                KL7Sim.this.repaintWin();
            } else {
                System.out.println("Mouse click in wrong object!");
            }
            KL7Sim.this.repaintWin();
            KL7Sim.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }
    }

    class MSimpleListener
    extends MouseAdapter {
        MSimpleListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == KL7Sim.this.lblModeRight) {
                KL7Sim.this.moveModeRight();
            } else if (e.getSource() == KL7Sim.this.lblModeLeft) {
                KL7Sim.this.moveModeLeft();
            } else if (e.getSource() == KL7Sim.this.outputTape) {
                if (KL7Sim.this.rbox.getBoxMode() != BoxMode.O) {
                    KL7Sim.this.klp.setTextArea(KL7Sim.this.fullOutputText);
                }
                KL7Sim.this.klp.setVisible(true);
                KL7Sim.this.repaintWin();
                KL7Sim.this.setCounterDisp();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class SoftMouse
    extends MouseAdapter {
        private char ch;

        public SoftMouse(char c) {
            this.ch = c;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.ch == '~') {
                KL7Sim.this.repeatNext = true;
                return;
            }
            this.softKeyEntered(this.ch);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (KL7Sim.this.tRpt != null) {
                KL7Sim.this.tRpt.interrupt();
            }
            if (this.ch != '~') {
                KL7Sim.this.repeatNext = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        public void softKeyEntered(char ch) {
            KL7Sim.this.bM = KL7Sim.this.rbox.getBoxMode();
            KL7Sim.this.bReg = KL7Sim.this.rbox.getReg();
            if (KL7Sim.this.bM == BoxMode.O) {
                return;
            }
            if (ch == '{' || ch == '}') {
                Register rch;
                Register register = rch = ch == '{' ? Register.FIG : Register.LET;
                if (KL7Sim.this.bM == BoxMode.P) {
                    KL7Sim.this.rbox.setReg(rch);
                    KL7Sim.this.setRegLamp();
                    return;
                }
            }
            if (ch == '~') {
                KL7Sim.this.repeatNext = true;
                return;
            }
            if (KL7Sim.this.enableRPT && KL7Sim.this.repeatNext && ch != '{' && ch != '}') {
                KL7Sim.this.tRpt = new Thread(new SoftMouseThread(ch, KL7Sim.this.bM, KL7Sim.this.bReg));
                KL7Sim.this.tRpt.start();
            } else {
                this.processSoftChar(ch, KL7Sim.this.bM, KL7Sim.this.bReg);
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            KL7Sim.this.setRegLamp();
            KL7Sim.this.repaintWin();
        }

        void processSoftChar(char ch, BoxMode bM, Register bReg) {
            switch (bM) {
                case P: {
                    if (bReg == Register.FIG && "QWERTYUIOP".indexOf(ch) != -1) {
                        ch = KL7Sim.this.letToDigSubst(ch);
                    }
                    KL7Sim.this.plainChar(ch);
                    break;
                }
                case E: {
                    if (bReg == Register.FIG && "QWERTYUIOP".indexOf(ch) != -1) {
                        ch = KL7Sim.this.letToDigSubst(ch);
                    }
                    KL7Sim.this.encryptChar(ch);
                    break;
                }
                case D: {
                    if (!Character.isLetter(ch)) {
                        return;
                    }
                    KL7Sim.this.decryptChar(ch);
                    break;
                }
                default: {
                    System.err.println("Got a WEIRD Box mode: " + (Object)((Object)KL7Sim.this.rbox.getBoxMode()));
                }
            }
        }

        class SoftMouseThread
        implements Runnable {
            char ch;
            BoxMode bM;
            Register bReg;

            public SoftMouseThread() {
            }

            public SoftMouseThread(char ch, BoxMode bM, Register bReg) {
                this();
                this.reconfThread(ch, bM, bReg);
            }

            void reconfThread(char ch, BoxMode bM, Register bReg) {
                this.ch = ch;
                this.bM = bM;
                this.bReg = bReg;
            }

            @Override
            public void run() {
                this.softThread();
            }

            public void softThread() {
                do {
                    if (KL7Sim.this.repeatNext) {
                        SoftMouse.this.processSoftChar(this.ch, this.bM, this.bReg);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ex) {
                        KL7Sim.this.repeatNext = false;
                        break;
                    }
                } while (KL7Sim.this.repeatNext);
            }
        }
    }
}

