/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.KL7Sim;
import gui.UppercaseDocumentFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import kl7.Box;
import kl7.BoxMode;

public class Kl7AutoType
extends JFrame {
    static final long serialVersionUID = 52527904L;
    private KL7Sim ksim;
    private Box box;
    private Kl7AutoType kaut;
    private JFileChooser fc;
    private StringBuffer txtBuf;
    private FileInputStream inputStream;
    private final JComboBox<String> fastRun;
    private Font font = new Font("Courier New", 0, 14);
    private long delay = 250L;

    public Kl7AutoType(KL7Sim ksim, Box box) {
        this();
        this.ksim = ksim;
        this.box = box;
        this.fc = new JFileChooser();
        this.fc.setFileFilter(new TxtFilter());
        this.txtBuf = new StringBuffer("");
        this.kaut = this;
    }

    public Kl7AutoType() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.setTitle("KL-7 Auto Typing");
        String osName = System.getProperty("os.name");
        if (osName.matches("Linux")) {
            this.setBounds(15, 15, 537, 450);
            this.setPreferredSize(new Dimension(537, 450));
        } else {
            this.setBounds(15, 15, 520, 450);
            this.setPreferredSize(new Dimension(520, 450));
        }
        this.setVisible(false);
        JLabel lblTheKlWill = new JLabel("The KL-7 will only process letters, numbers and spaces in P and E mode, and only letters in D mode.");
        lblTheKlWill.setFont(new Font("SansSerif", 0, 10));
        lblTheKlWill.setHorizontalAlignment(0);
        if (osName.matches("Linux.*") || osName.matches(".*Windows.*")) {
            lblTheKlWill.setFont(new Font("Helvetica", 0, 10));
        } else {
            lblTheKlWill.setFont(new Font("Arial Narrow", 0, 12));
        }
        this.getContentPane().add((Component)lblTheKlWill, "North");
        final JTextArea textArea = new JTextArea();
        textArea.setEditable(true);
        textArea.setBorder(new BevelBorder(1, null, null, null, null));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(this.font);
        JScrollPane scrollText = new JScrollPane(textArea);
        scrollText.setEnabled(true);
        scrollText.setHorizontalScrollBarPolicy(31);
        scrollText.setVerticalScrollBarPolicy(20);
        this.getContentPane().add((Component)scrollText, "Center");
        UppercaseDocumentFilter filter = new UppercaseDocumentFilter();
        ((AbstractDocument)textArea.getDocument()).setDocumentFilter(filter);
        JPanel panel = new JPanel();
        panel.setAlignmentX(1.0f);
        this.getContentPane().add((Component)panel, "South");
        this.fastRun = new JComboBox();
        this.fastRun.setFont(new Font("SansSerif", 0, 9));
        this.fastRun.setModel(new DefaultComboBoxModel<String>(new String[]{"Slow", "Normal", "Fast"}));
        this.fastRun.setSelectedIndex(1);
        JButton btnGetClipboard = new JButton("Get Clipboard");
        btnGetClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String clipboardText = "";
                Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                try {
                    if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        clipboardText = (String)trans.getTransferData(DataFlavor.stringFlavor);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Clipboard does not contain usable strings! " + ex.getMessage(), "Clipboard contents unsuitable", 0);
                    return;
                }
                catch (UnsupportedFlavorException ex1) {
                    JOptionPane.showMessageDialog(null, "Clipboard does not contain usable strings! " + ex1.getMessage(), "Clipboard contents unsuitable", 0);
                    return;
                }
                clipboardText = Kl7AutoType.this.filterString(clipboardText);
                textArea.setText(clipboardText);
            }
        });
        JButton btnGetFile = new JButton("Get File");
        btnGetFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = Kl7AutoType.this.fc.showOpenDialog(Kl7AutoType.this.kaut);
                switch (result) {
                    case 0: {
                        File inf = Kl7AutoType.this.fc.getSelectedFile();
                        Scanner scr = null;
                        if (inf.exists()) {
                            try {
                                try {
                                    Kl7AutoType.this.inputStream = new FileInputStream(inf);
                                    scr = new Scanner(Kl7AutoType.this.inputStream);
                                    while (scr.hasNext()) {
                                        Kl7AutoType.this.txtBuf.append(scr.nextLine());
                                    }
                                    textArea.setText(Kl7AutoType.this.txtBuf.toString());
                                    Kl7AutoType.this.txtBuf.delete(0, Kl7AutoType.this.txtBuf.length());
                                    scr.close();
                                    Kl7AutoType.this.inputStream.close();
                                }
                                catch (IOException exep) {
                                    textArea.setText("");
                                    JOptionPane.showMessageDialog(null, "Could not read file \"" + inf.getName() + "\" " + exep.getMessage(), "Error reading file", 0);
                                    exep.printStackTrace();
                                }
                            }
                            catch (Throwable throwable) {}
                            try {
                                if (scr != null) {
                                    scr.close();
                                }
                                if (Kl7AutoType.this.inputStream != null) {
                                    Kl7AutoType.this.inputStream.close();
                                }
                            }
                            catch (IOException ioexp) {
                                try {
                                    if (Kl7AutoType.this.inputStream != null) {
                                        Kl7AutoType.this.inputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "File \"" + inf.getName() + "\" does not exist!", "File not found", 0);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(null, "Problem opening or reading file", "Could not use this file", 0);
                    }
                }
            }
        });
        JButton btnStart = new JButton("Start");
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxMode bm = Kl7AutoType.this.box.getBoxMode();
                String s = textArea.getText();
                String ss = Kl7AutoType.this.filterString(s);
                switch (bm) {
                    case P: {
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 2) {
                            s = ss;
                            break;
                        }
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 0) {
                            Kl7AutoType.this.delay = 600L;
                        } else {
                            Kl7AutoType.this.delay = 250L;
                        }
                        Kl7AutoType.this.setVisible(false);
                        Kl7AutoType.this.ksim.setAbort(false);
                        Thread thread = new Thread(new PlainThread(ss));
                        thread.start();
                        break;
                    }
                    case E: {
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 2) {
                            s = Kl7AutoType.this.box.encryptString(ss);
                            break;
                        }
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 0) {
                            Kl7AutoType.this.delay = 600L;
                        } else {
                            Kl7AutoType.this.delay = 250L;
                        }
                        Kl7AutoType.this.setVisible(false);
                        Kl7AutoType.this.ksim.setAbort(false);
                        Thread thread = new Thread(new EncThread(ss));
                        thread.start();
                        break;
                    }
                    case D: {
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 2) {
                            s = Kl7AutoType.this.box.decryptString(ss);
                            break;
                        }
                        if (Kl7AutoType.this.fastRun.getSelectedIndex() == 0) {
                            Kl7AutoType.this.delay = 600L;
                        } else {
                            Kl7AutoType.this.delay = 250L;
                        }
                        Kl7AutoType.this.setVisible(false);
                        Kl7AutoType.this.ksim.setAbort(false);
                        Thread thread = new Thread(new DecThread(ss));
                        thread.start();
                        break;
                    }
                    default: {
                        Kl7AutoType.this.setVisible(false);
                        return;
                    }
                }
                if (Kl7AutoType.this.fastRun.getSelectedIndex() == 2) {
                    Kl7AutoType.this.ksim.addOutputText(s);
                }
                Kl7AutoType.this.ksim.setRegLamp();
                Kl7AutoType.this.setVisible(false);
            }
        });
        JButton btnClose = new JButton("Close");
        btnClose.setAlignmentX(1.0f);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Kl7AutoType.this.setVisible(false);
            }
        });
        JButton btnClear = new JButton("Clear");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.setText("");
            }
        });
        JButton btnSave = new JButton("Save");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintWriter prout = null;
                int result = Kl7AutoType.this.fc.showSaveDialog(Kl7AutoType.this.kaut);
                switch (result) {
                    case 0: {
                        File of = Kl7AutoType.this.fc.getSelectedFile();
                        try {
                            try {
                                String[] ss;
                                prout = new PrintWriter(of);
                                String s = textArea.getText().toUpperCase();
                                String[] stringArray = ss = s.split("(\\r|\\n)");
                                int n = ss.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String str = stringArray[n2];
                                    str = str.replaceAll("\\s{2,}", " ");
                                    if ((str = str.replaceAll("\\r", " ")).length() <= 60) {
                                        prout.println(str);
                                    } else {
                                        int i = 0;
                                        int k = 60;
                                        while (k <= str.length()) {
                                            if ((k = str.lastIndexOf(32, k)) <= 0) continue;
                                            prout.println(str.substring(i, k + 1));
                                            i = k + 1;
                                            k += 60;
                                        }
                                        if (i < str.length()) {
                                            prout.println(str.substring(i));
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            catch (IOException ioex1) {
                                JOptionPane.showMessageDialog(null, "Could not save to file \"" + of.getName() + "\" " + ioex1.getMessage(), "Error writing file", 0);
                                ioex1.printStackTrace();
                                if (prout == null) break;
                                prout.close();
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            if (prout != null) {
                                prout.close();
                            }
                            throw throwable;
                        }
                        if (prout == null) break;
                        prout.close();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(null, "Problem opening or writing to file", "Could not use this file", 0);
                    }
                }
            }
        });
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addComponent(this.fastRun, -2, -1, -2).addGap(5).addComponent(btnClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnGetClipboard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnGetFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnClose).addContainerGap()));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fastRun, -2, -1, -2).addComponent(btnClear).addComponent(btnGetClipboard).addComponent(btnClose).addComponent(btnStart).addComponent(btnGetFile).addComponent(btnSave)));
        panel.setLayout(gl_panel);
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "West");
        JPanel panel_2 = new JPanel();
        this.getContentPane().add((Component)panel_2, "East");
    }

    String filterString(String in) {
        BoxMode bm = this.box.getBoxMode();
        StringBuffer b = new StringBuffer();
        if (in.length() == 0 || in.equals("")) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if (Character.isLetter(ch)) {
                b.append(Character.toUpperCase(ch));
            } else if (Character.isWhitespace(ch) || Character.isDigit(ch) && (bm == BoxMode.P || bm == BoxMode.E)) {
                b.append(ch);
            } else {
                b.append(' ');
            }
            ++i;
        }
        return b.toString();
    }

    void setNewBox(Box b) {
        this.box = b;
    }

    class DecThread
    implements Runnable {
        private String s;

        public DecThread(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.decString();
        }

        public void decString() {
            int i = 0;
            while (i < this.s.length()) {
                Kl7AutoType.this.ksim.decryptChar(this.s.charAt(i));
                try {
                    Thread.currentThread();
                    Thread.sleep(Kl7AutoType.this.delay);
                }
                catch (InterruptedException e1) {
                    Kl7AutoType.this.ksim.setAutoRun(false);
                    break;
                }
                if (Kl7AutoType.this.ksim.getAbort()) break;
                ++i;
            }
        }
    }

    class EncThread
    implements Runnable {
        private String s;

        public EncThread(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.encString();
        }

        public void encString() {
            Kl7AutoType.this.ksim.setAutoRun(true);
            int i = 0;
            while (i < this.s.length()) {
                Kl7AutoType.this.ksim.encryptChar(this.s.charAt(i));
                try {
                    Thread.currentThread();
                    Thread.sleep(Kl7AutoType.this.delay);
                }
                catch (InterruptedException e1) {
                    Kl7AutoType.this.ksim.setAutoRun(false);
                    break;
                }
                if (Kl7AutoType.this.ksim.getAbort()) break;
                ++i;
            }
            Kl7AutoType.this.ksim.setAutoRun(false);
        }
    }

    class PlainThread
    implements Runnable {
        private String s;

        public PlainThread(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.plainString();
        }

        public void plainString() {
            int i = 0;
            while (i < this.s.length()) {
                Kl7AutoType.this.ksim.plainChar(this.s.charAt(i));
                try {
                    Thread.currentThread();
                    Thread.sleep(Kl7AutoType.this.delay);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (Kl7AutoType.this.ksim.getAbort()) break;
                ++i;
            }
        }
    }

    class TxtFilter
    extends FileFilter {
        TxtFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            return filename.endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "*.txt";
        }
    }
}

