/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.KL7Sim;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import kl7.Box;

public class MsgKeySet
extends JFrame {
    private static final int _0X359757 = 3512151;
    static final long serialVersionUID = 3512151L;
    private Box box;
    private KL7Sim dp3;
    private SwingAction setAction;
    private SwingAction cancelAction;
    private SwingAction defaultAction;
    private SwingAction stringAction;
    private static final String[] nRingMark = new String[]{"A", "B", "B+", "C", "D", "E", "E+", "F", "G", "G+", "H", "I", "J", "J+", "K", "L", "M", "M+", "N", "O", "O+", "P", "Q", "R", "R+", "S", "T", "T+", "U", "V", "W", "W+", "X", "Y", "Z", "Z+"};
    private static final String gkPat = "(A|B\\+?|C|D|E\\+?|F|G\\+?|H|I|J\\+?|K|L|M\\+?|N|O\\+?|P|Q|R\\+?|S|T\\+?|U|V|W\\+?|X|Y|Z\\+?){1,7}";
    private static final Pattern gp = Pattern.compile("(A|B\\+?|C|D|E\\+?|F|G\\+?|H|I|J\\+?|K|L|M\\+?|N|O\\+?|P|Q|R\\+?|S|T\\+?|U|V|W\\+?|X|Y|Z\\+?){1,7}");
    private JComboBox<String> comboBox;
    private JComboBox<String> comboBox_1;
    private JComboBox<String> comboBox_2;
    private JComboBox<String> comboBox_3;
    private JComboBox<String> comboBox_4;
    private JComboBox<String> comboBox_5;
    private JComboBox<String> comboBox_6;
    private ArrayList<String> kep;
    private int[] key;
    private static final String kPat = "([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)";
    private static final Pattern p = Pattern.compile("([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)([A-Z]\\+?)");
    private JPanel contentPane;
    private JTextField newKey;
    private CListen cl;

    public MsgKeySet(Box box, KL7Sim dp3) {
        this.setResizable(false);
        this.setTitle("Message Key Settings");
        this.key = new int[7];
        this.kep = new ArrayList(36);
        int i = 0;
        while (i < nRingMark.length) {
            this.kep.add(nRingMark[i]);
            ++i;
        }
        this.box = box;
        this.key = box.getIntKey();
        System.out.println();
        this.dp3 = dp3;
        this.cl = new CListen();
        this.setDefaultCloseOperation(2);
        this.contentPane = new JPanel();
        this.setBackground(Color.LIGHT_GRAY);
        this.setBounds(140, 60, 443, 228);
        this.setVisible(false);
        this.getContentPane().setLayout(null);
        this.setContentPane(this.contentPane);
        this.addComponentListener(this.cl);
        this.contentPane.setOpaque(true);
        this.contentPane.setBorder(new BevelBorder(0, Color.BLACK, null, Color.BLACK, Color.LIGHT_GRAY));
        this.contentPane.setLayout(null);
        this.setVisible(false);
        this.contentPane.setBorder(new EtchedBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
        this.contentPane.setToolTipText("Rotor letters visible through the cage window aginst the white mark");
        this.setFont(new Font("Lucida Grande", 1, 15));
        this.getContentPane().setLayout(null);
        JLabel lblNewLabel = new JLabel("Rotors:");
        lblNewLabel.setFont(new Font("Lucida Grande", 2, 13));
        lblNewLabel.setHorizontalAlignment(4);
        lblNewLabel.setBounds(6, 37, 57, 16);
        this.getContentPane().add(lblNewLabel);
        JLabel lblSettingMessageKey = new JLabel("Message Rotor Alignment");
        lblSettingMessageKey.setBounds(6, 6, 239, 19);
        lblSettingMessageKey.setFont(new Font("Lucida Grande", 1, 15));
        this.getContentPane().add(lblSettingMessageKey);
        JLabel label = new JLabel("1");
        label.setBounds(75, 37, 15, 16);
        this.getContentPane().add(label);
        JLabel label_1 = new JLabel("2");
        label_1.setBounds(167, 37, 15, 16);
        this.getContentPane().add(label_1);
        JLabel label_2 = new JLabel("3");
        label_2.setBounds(257, 37, 15, 16);
        this.getContentPane().add(label_2);
        JLabel label_3 = new JLabel("4");
        label_3.setBounds(345, 37, 23, 16);
        this.getContentPane().add(label_3);
        JLabel label_4 = new JLabel("5");
        label_4.setBounds(75, 65, 15, 16);
        this.getContentPane().add(label_4);
        JLabel label_5 = new JLabel("6");
        label_5.setBounds(167, 65, 15, 16);
        this.getContentPane().add(label_5);
        JLabel label_6 = new JLabel("7");
        label_6.setBounds(257, 65, 15, 16);
        this.getContentPane().add(label_6);
        JLabel label_7 = new JLabel("8");
        label_7.setBounds(345, 65, 23, 16);
        this.getContentPane().add(label_7);
        this.comboBox = new JComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox.setMaximumSize(new Dimension(70, 27));
        this.comboBox.setSize(new Dimension(70, 27));
        this.comboBox.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox.setMinimumSize(new Dimension(70, 27));
        this.comboBox.setPreferredSize(new Dimension(70, 27));
        this.comboBox.setBounds(85, 33, 70, 27);
        this.comboBox.setEditable(false);
        this.getContentPane().add(this.comboBox);
        this.comboBox_1 = new JComboBox();
        this.comboBox_1.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_1.setSize(new Dimension(70, 27));
        this.comboBox_1.setEditable(false);
        this.comboBox_1.setPreferredSize(new Dimension(70, 27));
        this.comboBox_1.setMinimumSize(new Dimension(70, 27));
        this.comboBox_1.setMaximumSize(new Dimension(70, 27));
        this.comboBox_1.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_1.setBounds(177, 33, 70, 27);
        this.getContentPane().add(this.comboBox_1);
        this.comboBox_2 = new JComboBox();
        this.comboBox_2.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_2.setSize(new Dimension(70, 27));
        this.comboBox_2.setEditable(false);
        this.comboBox_2.setPreferredSize(new Dimension(70, 27));
        this.comboBox_2.setMinimumSize(new Dimension(70, 27));
        this.comboBox_2.setMaximumSize(new Dimension(70, 27));
        this.comboBox_2.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_2.setBounds(267, 33, 70, 27);
        this.getContentPane().add(this.comboBox_2);
        JLabel lblNone = new JLabel("None");
        lblNone.setEnabled(false);
        lblNone.setFont(new Font("Lucida Grande", 1, 13));
        lblNone.setBounds(361, 37, 44, 16);
        this.getContentPane().add(lblNone);
        this.comboBox_3 = new JComboBox();
        this.comboBox_3.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_3.setSize(new Dimension(70, 27));
        this.comboBox_3.setEditable(false);
        this.comboBox_3.setPreferredSize(new Dimension(70, 27));
        this.comboBox_3.setMinimumSize(new Dimension(70, 27));
        this.comboBox_3.setMaximumSize(new Dimension(70, 27));
        this.comboBox_3.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_3.setBounds(85, 61, 70, 27);
        this.getContentPane().add(this.comboBox_3);
        this.comboBox_4 = new JComboBox();
        this.comboBox_4.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_4.setSize(new Dimension(70, 27));
        this.comboBox_4.setEditable(false);
        this.comboBox_4.setPreferredSize(new Dimension(70, 27));
        this.comboBox_4.setMinimumSize(new Dimension(70, 27));
        this.comboBox_4.setMaximumSize(new Dimension(70, 27));
        this.comboBox_4.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_4.setBounds(177, 61, 70, 27);
        this.getContentPane().add(this.comboBox_4);
        this.comboBox_5 = new JComboBox();
        this.comboBox_5.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_5.setSize(new Dimension(70, 27));
        this.comboBox_5.setEditable(false);
        this.comboBox_5.setPreferredSize(new Dimension(70, 27));
        this.comboBox_5.setMinimumSize(new Dimension(70, 27));
        this.comboBox_5.setMaximumSize(new Dimension(70, 27));
        this.comboBox_5.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_5.setBounds(267, 61, 70, 27);
        this.getContentPane().add(this.comboBox_5);
        this.comboBox_6 = new JComboBox();
        this.comboBox_6.setModel(new DefaultComboBoxModel<String>(nRingMark));
        this.comboBox_6.setSize(new Dimension(70, 27));
        this.comboBox_6.setEditable(false);
        this.comboBox_6.setPreferredSize(new Dimension(70, 27));
        this.comboBox_6.setMinimumSize(new Dimension(70, 27));
        this.comboBox_6.setMaximumSize(new Dimension(70, 27));
        this.comboBox_6.setFont(new Font("Lucida Grande", 1, 12));
        this.comboBox_6.setBounds(355, 61, 70, 27);
        this.getContentPane().add(this.comboBox_6);
        this.setIntKey(this.key);
        JButton btnSet = new JButton("Set");
        btnSet.setToolTipText("Set visible rotor positions to the letters selected above");
        btnSet.setBounds(307, 107, 96, 29);
        this.getContentPane().add(btnSet);
        JButton btnDefault = new JButton("Default");
        btnDefault.setToolTipText("Set visible rotor positions to default positions (\"AAAAAAA\")");
        btnDefault.setBounds(174, 107, 96, 29);
        this.getContentPane().add(btnDefault);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setToolTipText("Do NOT change the existing message setting (current rotor poitions)");
        btnCancel.setBounds(37, 107, 100, 29);
        this.getContentPane().add(btnCancel);
        this.setAction = new SwingAction(0, this);
        this.cancelAction = new SwingAction(1, this);
        this.defaultAction = new SwingAction(2, this);
        this.stringAction = new SwingAction(3, this);
        btnSet.addActionListener(this.setAction);
        btnCancel.addActionListener(this.cancelAction);
        btnDefault.addActionListener(this.defaultAction);
        JButton btnString = new JButton("Set from string: ");
        btnString.setToolTipText("Click to intake the message key as a text string of 7 characters.");
        btnString.setBounds(16, 148, 139, 29);
        this.getContentPane().add(btnString);
        btnString.addActionListener(this.stringAction);
        this.newKey = new JTextField();
        this.newKey.setToolTipText("Type 7 letters (message key) here. Then click button to the left.");
        this.newKey.setColumns(7);
        this.newKey.setBounds(167, 148, 100, 29);
        this.newKey.setEditable(true);
        KeyDocumentFilter filter = new KeyDocumentFilter();
        ((AbstractDocument)this.newKey.getDocument()).setDocumentFilter(filter);
        this.getContentPane().add(this.newKey);
    }

    void setKey(String key) {
        if (key.length() != 7) {
            System.out.println("msgSetKey: key of wrong length " + key.length() + " (must be 7)");
            return;
        }
        this.comboBox.setSelectedItem(String.valueOf(key.charAt(0)));
        this.comboBox_1.setSelectedItem(String.valueOf(key.charAt(1)));
        this.comboBox_2.setSelectedItem(String.valueOf(key.charAt(2)));
        this.comboBox_3.setSelectedItem(String.valueOf(key.charAt(3)));
        this.comboBox_4.setSelectedItem(String.valueOf(key.charAt(4)));
        this.comboBox_5.setSelectedItem(String.valueOf(key.charAt(5)));
        this.comboBox_6.setSelectedItem(String.valueOf(key.charAt(6)));
    }

    void setIntKey(int[] key) {
        this.comboBox.setSelectedIndex(key[0]);
        this.comboBox_1.setSelectedIndex(key[1]);
        this.comboBox_2.setSelectedIndex(key[2]);
        this.comboBox_3.setSelectedIndex(key[3]);
        this.comboBox_4.setSelectedIndex(key[4]);
        this.comboBox_5.setSelectedIndex(key[5]);
        this.comboBox_6.setSelectedIndex(key[6]);
    }

    public void setNewBox(Box b) {
        this.box = b;
    }

    private class CListen
    implements ComponentListener {
        private CListen() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            MsgKeySet.this.key = MsgKeySet.this.box.getIntKey();
            MsgKeySet.this.setIntKey(MsgKeySet.this.key);
        }
    }

    private class KeyDocumentFilter
    extends DocumentFilter {
        String newText = "";

        private KeyDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) {
            try {
                this.newText = text.replaceAll("[^a-zA-Z\\+]", "");
                fb.insertString(offset, text.toUpperCase(), attr);
                int i = fb.getDocument().getLength();
                int k = text.indexOf(43, 0);
                while (k > 0) {
                    --i;
                    k = text.indexOf(43, k + 1);
                }
                if (i > 7) {
                    fb.remove(7, i - 7);
                }
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace();
            }
            catch (BadLocationException ex1) {
                ex1.printStackTrace();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
            try {
                text = this.newText = text.replaceAll("[^a-zA-Z\\+]", "");
                fb.replace(offset, length, text.toUpperCase(), attrs);
                int i = fb.getDocument().getLength();
                Document d = fb.getDocument();
                Matcher m = gp.matcher(d.getText(0, i));
                if (!m.matches()) {
                    fb.remove(i - 1, 1);
                    return;
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class SwingAction
    extends AbstractAction {
        static final long serialVersionUID = 3315545L;
        private MsgKeySet ms;
        private int which;

        public SwingAction(int i, MsgKeySet ms) {
            this.ms = ms;
            switch (i) {
                case 0: {
                    this.putValue("Name", "Set");
                    this.putValue("ShortDescription", "Button to set rotors for Message Key.");
                    this.which = 0;
                    break;
                }
                case 1: {
                    this.putValue("Name", "Cancel");
                    this.putValue("ShortDescription", "Button to leave everything as is.");
                    this.which = 1;
                    break;
                }
                case 2: {
                    this.putValue("Name", "Default");
                    this.putValue("ShortDescription", "Button to set all the rotors to \"A\" position.");
                    this.which = 2;
                    break;
                }
                case 3: {
                    this.putValue("Name", "String");
                    this.putValue("ShortDescription", "Button to take the string and use it as 7-char key.");
                    this.which = 3;
                    break;
                }
                default: {
                    System.out.println("SwingAction: got wrong index: " + i);
                    this.which = 1;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.which) {
                case 0: {
                    this.setTheBox();
                    break;
                }
                case 1: {
                    this.restoreSelection();
                    this.ms.setVisible(false);
                    break;
                }
                case 2: {
                    this.setDefaultKey();
                    MsgKeySet.this.dp3.repaintWin();
                    this.ms.setVisible(false);
                    break;
                }
                case 3: {
                    this.getKeyFromString();
                    break;
                }
                default: {
                    System.out.println("Wrong value - exiting...");
                    MsgKeySet.this.box.dumpBox();
                    System.exit(-1);
                }
            }
        }

        void getKeyFromString() {
            int z = 0;
            int i = 0;
            String k = MsgKeySet.this.newKey.getText();
            Matcher m = p.matcher(k);
            if (!m.matches()) {
                System.err.println("msgKey \"" + k + "\" is wrong (" + k.length() + ")");
                return;
            }
            i = 0;
            while (i < 7) {
                k = m.group(i + 1);
                ((MsgKeySet)MsgKeySet.this).key[i] = z = MsgKeySet.this.kep.indexOf(k);
                if (z < 0) {
                    System.err.println("msgKey \"" + k + "\" in pos " + (i + 1) + " is incorrect (" + k.length() + ")");
                    return;
                }
                ++i;
            }
            MsgKeySet.this.setIntKey(MsgKeySet.this.key);
            this.setTheBox();
        }

        void setTheBox() {
            if (!this.setBoxRotors()) {
                return;
            }
            MsgKeySet.this.key = MsgKeySet.this.box.getIntKey();
            MsgKeySet.this.dp3.repaintWin();
            this.ms.setVisible(false);
        }

        boolean setBoxRotors() {
            int[] key = new int[]{MsgKeySet.this.comboBox.getSelectedIndex(), MsgKeySet.this.comboBox_1.getSelectedIndex(), MsgKeySet.this.comboBox_2.getSelectedIndex(), MsgKeySet.this.comboBox_3.getSelectedIndex(), MsgKeySet.this.comboBox_4.getSelectedIndex(), MsgKeySet.this.comboBox_5.getSelectedIndex(), MsgKeySet.this.comboBox_6.getSelectedIndex()};
            MsgKeySet.this.box.setMsgKey(key);
            return true;
        }

        void restoreSelection() {
            MsgKeySet.this.setIntKey(MsgKeySet.this.key);
        }

        void setDefaultKey() {
            MsgKeySet.this.box.setMsgKey("AAAAAAA");
            MsgKeySet.this.comboBox.setSelectedIndex(0);
            MsgKeySet.this.comboBox_1.setSelectedIndex(0);
            MsgKeySet.this.comboBox_2.setSelectedIndex(0);
            MsgKeySet.this.comboBox_3.setSelectedIndex(0);
            MsgKeySet.this.comboBox_4.setSelectedIndex(0);
            MsgKeySet.this.comboBox_5.setSelectedIndex(0);
            MsgKeySet.this.comboBox_6.setSelectedIndex(0);
        }
    }
}

