/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.XTEA;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.swing.JOptionPane;

public class RndXtea
extends SecureRandom {
    private static final long serialVersionUID = 4404366351435991345L;
    private XTEA xt;
    private byte[] xkey;
    private byte[] xiv;
    private int isize = 4;
    private byte[] itmp = new byte[this.isize];

    public static void main(String[] args) {
        int i = 0;
        int x = 0;
        byte[] tmp = new byte[15];
        RndXtea rnd = new RndXtea("testing2");
        rnd.nextBytes(tmp);
        System.out.println("Rnd bytes: " + XTEA.getHex(tmp));
        i = 0;
        while (i < 10) {
            x = 26 + i * 5;
            System.out.println("Rnd int:   " + rnd.nextInt(x) + " \ti=" + i + " x=" + x);
            ++i;
        }
    }

    public RndXtea() {
        this.xkey = new byte[16];
        this.xiv = new byte[8];
    }

    public RndXtea(String key) {
        this();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException cex2) {
            cex2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not generate pseudorandom seed from given password - Sha512 not supported...", "SERIOUS ERROR", 0);
            return;
        }
        md.update(key.getBytes());
        md.update("codebooking".getBytes());
        byte[] digest = md.digest();
        this.setSeed(digest);
    }

    @Override
    public void setSeed(byte[] key) {
        int i = 0;
        if (key.length < 24) {
            throw new IllegalArgumentException("Input digest too short! got=" + key.length + " needed>=" + 24);
        }
        i = 0;
        while (i < this.isize) {
            this.itmp[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.xiv[i] = key[i];
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.xkey[i] = key[i + 8];
            ++i;
        }
        this.xt = new XTEA();
        try {
            this.xt.engineInit(this.xkey, false);
            this.xt.initOFB(this.xiv);
        }
        catch (InvalidKeyException inkek) {
            inkek.printStackTrace();
        }
    }

    @Override
    public int nextInt(int x) {
        int z = 0;
        byte[] it = this.xt.encryptOFB(this.itmp);
        int i = 0;
        while (i < it.length) {
            z = z * 8 + it[i];
            ++i;
        }
        z %= x;
        while (z < 0) {
            z += x;
        }
        return z;
    }

    @Override
    public long nextLong(long x) {
        int sz = 8;
        int i = 0;
        int r = 0;
        byte[] iln = new byte[sz];
        i = 0;
        while (i < sz) {
            iln[i] = 0;
            ++i;
        }
        byte[] z = this.xt.encryptOFB(iln);
        i = 0;
        while (i < sz) {
            r = r * 8 + z[i];
            ++i;
        }
        r = (int)((long)r % x);
        while (r < 0) {
            r = (int)((long)r + x);
        }
        return r;
    }

    @Override
    public void nextBytes(byte[] x) {
        byte[] z = this.xt.encryptOFB(x);
        int i = 0;
        while (i < x.length) {
            x[i] = z[i];
            ++i;
        }
    }
}

