/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.security.InvalidKeyException;
import java.security.SecureRandom;

public class XTEA {
    private static final int ROUNDS = 64;
    static final int BLOCK_SIZE = 8;
    static final int KEY_SIZE = 16;
    private static final int DELTA = -1640531527;
    private static final int D_SUM = -957401312;
    private static SecureRandom rnd = new SecureRandom();
    private int[] S = new int[4];
    private int[] Ctr_IV = new int[2];
    private byte[] ctr_out = null;
    private byte[] ofb_out = null;
    private int ctr_pos = 0;
    private int ofb_pos = 0;
    private boolean decrypt = false;
    static final String HEXES = "0123456789ABCDEF".toLowerCase();

    public void engineInit(byte[] key, boolean decipher) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        if (key.length != 16) {
            throw new InvalidKeyException("Invalid key length (req. 16 bytes)");
        }
        this.generateSubKeys(key);
        this.decrypt = decipher;
    }

    public byte[] engineCrypt(byte[] in, int inOffset) {
        int v0 = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset++] << 24;
        int v1 = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset++] << 24;
        int n = 64;
        int sum = 0;
        if (!this.decrypt) {
            sum = 0;
            while (n-- > 0) {
                v1 += ((v0 += (v1 << 4 ^ v1 >>> 5) + v1 ^ sum + this.S[sum & 3]) << 4 ^ v0 >>> 5) + v0 ^ (sum += -1640531527) + this.S[sum >> 11 & 3];
            }
        } else {
            sum = -957401312;
            while (n-- > 0) {
                v0 -= ((v1 -= (v0 << 4 ^ v0 >>> 5) + v0 ^ sum + this.S[sum >> 11 & 3]) << 4 ^ v1 >>> 5) + v1 ^ (sum -= -1640531527) + this.S[sum & 3];
            }
        }
        int outOffset = 0;
        byte[] out = new byte[8];
        out[outOffset++] = (byte)v0;
        out[outOffset++] = (byte)(v0 >>> 8);
        out[outOffset++] = (byte)(v0 >>> 16);
        out[outOffset++] = (byte)(v0 >>> 24);
        out[outOffset++] = (byte)v1;
        out[outOffset++] = (byte)(v1 >>> 8);
        out[outOffset++] = (byte)(v1 >>> 16);
        out[outOffset++] = (byte)(v1 >>> 24);
        return out;
    }

    private void generateSubKeys(byte[] key) {
        int off = 0;
        int i = 0;
        while (i < 4) {
            this.S[i] = key[off++] & 0xFF | (key[off++] & 0xFF) << 8 | (key[off++] & 0xFF) << 16 | (key[off++] & 0xFF) << 24;
            ++i;
        }
    }

    public void initCTR(byte[] iv) {
        this.Ctr_IV[0] = 0;
        this.Ctr_IV[1] = 0;
        if (iv == null) {
            return;
        }
        int i = iv.length - 1;
        while (i >= 0) {
            this.Ctr_IV[1] = this.Ctr_IV[1] << 8;
            this.Ctr_IV[1] = this.Ctr_IV[1] + iv[i];
            --i;
        }
    }

    public void initOFB(byte[] iv) {
        if (iv == null) {
            iv = new byte[8];
            int i = 0;
            while (i < 8) {
                iv[i] = 0;
                ++i;
            }
        }
        this.ofb_out = this.engineCrypt(iv, 0);
        this.ofb_pos = 0;
    }

    private void _calcOFBBUF() {
        this.ofb_out = this.engineCrypt(this.ofb_out, 0);
        this.ofb_pos = 0;
    }

    private byte _nextOFBByte() {
        byte b = this.ofb_out[this.ofb_pos];
        ++this.ofb_pos;
        if (this.ofb_pos >= this.ofb_out.length) {
            this._calcOFBBUF();
        }
        return b;
    }

    private void _calcCTRBUF() {
        String cbuf = String.valueOf(String.valueOf(this.Ctr_IV[0])) + String.valueOf(this.Ctr_IV[1]);
        this.ctr_out = this.engineCrypt(cbuf.getBytes(), 0);
        this.Ctr_IV[1] = this.Ctr_IV[1] + 1;
        if (this.Ctr_IV[1] >= -1) {
            this.Ctr_IV[0] = this.Ctr_IV[0] + 1;
            this.Ctr_IV[1] = 0;
        }
        this.ctr_pos = 0;
    }

    private byte _nextCTRByte() {
        byte b = this.ctr_out[this.ctr_pos];
        ++this.ctr_pos;
        if (this.ctr_pos >= this.ctr_out.length) {
            this._calcCTRBUF();
        }
        return b;
    }

    public byte[] encryptCTR(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Empty data!");
        }
        byte[] out = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            out[i] = (byte)((this._nextCTRByte() ^ data[i]) & 0xFF);
            ++i;
        }
        return out;
    }

    public byte[] decryptCTR(byte[] data) {
        return this.encryptCTR(data);
    }

    public byte[] encryptOFB(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Empty data!");
        }
        byte[] out = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            out[i] = (byte)((this._nextOFBByte() ^ data[i]) & 0xFF);
            ++i;
        }
        return out;
    }

    public byte[] decryptOFB(byte[] data) {
        return this.encryptOFB(data);
    }

    private byte[] addPKCS7(byte[] s) {
        int len = 8 - s.length % 8;
        byte[] s1 = new byte[s.length + len];
        int i = 0;
        while (i < s.length) {
            s1[i] = s[i];
            ++i;
        }
        if (len > 0) {
            byte z = (byte)(len & 0xFF);
            while (i < s.length + len) {
                s1[i] = z;
                ++i;
            }
        }
        return s1;
    }

    private byte[] removePKCS7(byte[] s) {
        int len = s.length;
        byte z = s[len - 1];
        if (z > 0 && z < 8) {
            int i = len - 1;
            while (i > len - z) {
                if (s[i] != z) {
                    return s;
                }
                --i;
            }
            byte[] s1 = new byte[len - z];
            i = 0;
            while (i < len - z) {
                s1[i] = s[i];
                ++i;
            }
            return s1;
        }
        return s;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            ++n2;
        }
        return hex.toString();
    }

    public static void main(String[] args) {
        XTEA xt = new XTEA();
        byte[] key = new byte[16];
        byte[] iv = new byte[8];
        String pt = "this is a test I'd love to see tried and verified.";
        rnd.nextBytes(key);
        rnd.nextBytes(iv);
        try {
            xt.engineInit(key, false);
            xt.initOFB(iv);
            byte[] ct1 = pt.getBytes();
            byte[] ct = xt.encryptOFB(ct1);
            xt.initOFB(iv);
            byte[] pt1 = xt.decryptOFB(ct);
            System.out.println("PT:  " + pt + "  " + pt.length());
            System.out.println("CT:  " + XTEA.getHex(ct) + "  " + ct.length);
            System.out.println("PT1: " + new String(pt1) + "  " + pt1.length);
        }
        catch (InvalidKeyException invex) {
            invex.printStackTrace();
            System.exit(-2);
        }
    }
}

