/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import java.io.Serializable;

public class BasePlate
implements Serializable {
    private static final long serialVersionUID = 8211640577341033353L;
    final byte[] basePlate;
    final String basePlateVNew = "VER24D5QT6UH8YSIOJCX7L1AW0BZ3PM9KNGF";
    final String basePlateVal = "QP0NFC3YOM9GR8UI7BH2VTW6XS4JLZ5DKEA1";
    byte[] currPlate;
    byte[] reverseMap;

    public BasePlate() {
        byte[] byArray = new byte[36];
        byArray[0] = 81;
        byArray[1] = 80;
        byArray[3] = 78;
        byArray[4] = 70;
        byArray[5] = 67;
        byArray[6] = 3;
        byArray[7] = 89;
        byArray[8] = 79;
        byArray[9] = 77;
        byArray[10] = 9;
        byArray[11] = 71;
        byArray[12] = 82;
        byArray[13] = 8;
        byArray[14] = 85;
        byArray[15] = 73;
        byArray[16] = 7;
        byArray[17] = 66;
        byArray[18] = 72;
        byArray[19] = 2;
        byArray[20] = 86;
        byArray[21] = 84;
        byArray[22] = 87;
        byArray[23] = 6;
        byArray[24] = 88;
        byArray[25] = 83;
        byArray[26] = 4;
        byArray[27] = 74;
        byArray[28] = 76;
        byArray[29] = 90;
        byArray[30] = 5;
        byArray[31] = 68;
        byArray[32] = 75;
        byArray[33] = 69;
        byArray[34] = 65;
        byArray[35] = 1;
        this.basePlate = byArray;
        this.basePlateVNew = "VER24D5QT6UH8YSIOJCX7L1AW0BZ3PM9KNGF";
        this.basePlateVal = "QP0NFC3YOM9GR8UI7BH2VTW6XS4JLZ5DKEA1";
        this.currPlate = null;
        this.reverseMap = new byte[256];
        this.currPlate = new byte[36];
        int i = 0;
        while (i < 256) {
            this.reverseMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 36) {
            if (Character.isLetter(this.basePlate[i])) {
                this.currPlate[i] = this.basePlate[i];
                this.reverseMap[this.basePlate[i]] = (byte)i;
            } else {
                this.currPlate[i] = (byte)i;
                this.reverseMap[i] = (byte)i;
            }
            ++i;
        }
    }

    public BasePlate(String custom) {
        byte[] byArray = new byte[36];
        byArray[0] = 81;
        byArray[1] = 80;
        byArray[3] = 78;
        byArray[4] = 70;
        byArray[5] = 67;
        byArray[6] = 3;
        byArray[7] = 89;
        byArray[8] = 79;
        byArray[9] = 77;
        byArray[10] = 9;
        byArray[11] = 71;
        byArray[12] = 82;
        byArray[13] = 8;
        byArray[14] = 85;
        byArray[15] = 73;
        byArray[16] = 7;
        byArray[17] = 66;
        byArray[18] = 72;
        byArray[19] = 2;
        byArray[20] = 86;
        byArray[21] = 84;
        byArray[22] = 87;
        byArray[23] = 6;
        byArray[24] = 88;
        byArray[25] = 83;
        byArray[26] = 4;
        byArray[27] = 74;
        byArray[28] = 76;
        byArray[29] = 90;
        byArray[30] = 5;
        byArray[31] = 68;
        byArray[32] = 75;
        byArray[33] = 69;
        byArray[34] = 65;
        byArray[35] = 1;
        this.basePlate = byArray;
        this.basePlateVNew = "VER24D5QT6UH8YSIOJCX7L1AW0BZ3PM9KNGF";
        this.basePlateVal = "QP0NFC3YOM9GR8UI7BH2VTW6XS4JLZ5DKEA1";
        this.currPlate = null;
        this.currPlate = new byte[36];
        this.reverseMap = new byte[256];
        if (!custom.matches("\\w{36}")) {
            System.err.println("BasePlate(" + custom + ") malformed string!");
            return;
        }
        int i = 0;
        while (i < 256) {
            this.reverseMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 36) {
            char ch = custom.charAt(i);
            if (Character.isLetter(ch)) {
                this.currPlate[i] = (byte)ch;
            } else if (Character.isDigit(ch)) {
                this.currPlate[i] = (byte)i;
            }
            this.reverseMap[this.currPlate[i]] = (byte)i;
            ++i;
        }
        if (!this.validatePlate(this.currPlate)) {
            System.err.println("BasePlate(" + custom + ") failed validation!");
            return;
        }
    }

    boolean validatePlate(byte[] custom) {
        boolean result = false;
        byte[] duplicate = new byte[256];
        int i = 0;
        while (i < 256) {
            duplicate[i] = -1;
            ++i;
        }
        if (custom.length != 36) {
            result = false;
        }
        i = 0;
        while (i < 36) {
            byte ch = custom[i];
            if (!(ch >= 0 && ch <= 35 || Character.isLetter(ch))) {
                System.err.println("validatePlate(): found illegal byte '" + String.format("0x%02x", ch) + "' at index " + i);
                result = false;
                break;
            }
            if (duplicate[ch] != -1) {
                System.err.println("validatePlate(): found duplicate char '" + (char)ch + "' at index " + i);
                return false;
            }
            duplicate[ch] = ch;
            if (Character.isLetter(ch)) {
                if ("QP0NFC3YOM9GR8UI7BH2VTW6XS4JLZ5DKEA1".indexOf(ch = (byte)Character.toUpperCase(ch)) == -1) {
                    result = false;
                    break;
                }
                result = true;
            } else if (ch < 10 && ch >= 0) {
                result = true;
            }
            ++i;
        }
        if (!result) {
            System.err.println("Custom Base Plate failed validation!");
        }
        return result;
    }

    public boolean validateThisPlate() {
        return this.validatePlate(this.currPlate);
    }

    public byte enterCage(byte ch) {
        byte out = this.reverseMap[ch];
        return out;
    }

    public byte leaveCage(byte sym) {
        byte out = this.currPlate[sym];
        return out;
    }

    public void dumpPlate() {
        System.out.print("Base Plate:            ");
        int i = 0;
        while (i < 36) {
            System.out.print(String.valueOf(i) + "-" + this.currPlate[i] + " ");
            ++i;
        }
        System.out.println();
        System.out.print("Base Plate reverseMap: ");
        i = 0;
        while (i < 256) {
            if (this.reverseMap[i] != -1) {
                System.out.print(String.valueOf(i) + "-" + this.reverseMap[i] + " ");
            }
            ++i;
        }
        System.out.println("\n");
    }
}

