/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import java.io.Serializable;

public class NotchRing
implements Serializable {
    private static final long serialVersionUID = -1930415341527190187L;
    String name;
    int id;
    byte ringPos;
    byte alphPos = 0;
    int[] curNRing;
    static final int[] baseRing1;
    static final int[] baseRing2;
    static final int[] baseRing3;
    static final int[] baseRing4;
    static final int[] baseRing5;
    static final int[] baseRing6;
    static final int[] baseRing7;
    static final int[] baseRing8;
    static final int[] baseRing9;
    static final int[] baseRing10;
    static final int[] baseRing11;
    int[][] ring;

    static {
        int[] nArray = new int[36];
        nArray[0] = 1;
        nArray[4] = 1;
        nArray[9] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[16] = 1;
        nArray[18] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[26] = 1;
        nArray[27] = 1;
        nArray[30] = 1;
        nArray[31] = 1;
        nArray[35] = 1;
        baseRing1 = nArray;
        int[] nArray2 = new int[36];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[5] = 1;
        nArray2[7] = 1;
        nArray2[11] = 1;
        nArray2[13] = 1;
        nArray2[14] = 1;
        nArray2[18] = 1;
        nArray2[21] = 1;
        nArray2[22] = 1;
        nArray2[25] = 1;
        nArray2[27] = 1;
        nArray2[31] = 1;
        nArray2[34] = 1;
        nArray2[35] = 1;
        baseRing2 = nArray2;
        int[] nArray3 = new int[36];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[9] = 1;
        nArray3[14] = 1;
        nArray3[18] = 1;
        nArray3[23] = 1;
        nArray3[25] = 1;
        nArray3[27] = 1;
        nArray3[29] = 1;
        nArray3[31] = 1;
        nArray3[34] = 1;
        baseRing3 = nArray3;
        int[] nArray4 = new int[36];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArray4[6] = 1;
        nArray4[9] = 1;
        nArray4[13] = 1;
        nArray4[14] = 1;
        nArray4[17] = 1;
        nArray4[19] = 1;
        nArray4[24] = 1;
        nArray4[25] = 1;
        nArray4[26] = 1;
        nArray4[29] = 1;
        nArray4[30] = 1;
        nArray4[31] = 1;
        nArray4[33] = 1;
        baseRing4 = nArray4;
        int[] nArray5 = new int[36];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[10] = 1;
        nArray5[13] = 1;
        nArray5[17] = 1;
        nArray5[18] = 1;
        nArray5[21] = 1;
        nArray5[23] = 1;
        nArray5[25] = 1;
        nArray5[27] = 1;
        nArray5[28] = 1;
        nArray5[33] = 1;
        nArray5[34] = 1;
        baseRing5 = nArray5;
        int[] nArray6 = new int[36];
        nArray6[5] = 1;
        nArray6[6] = 1;
        nArray6[7] = 1;
        nArray6[10] = 1;
        nArray6[11] = 1;
        nArray6[15] = 1;
        nArray6[17] = 1;
        nArray6[21] = 1;
        nArray6[22] = 1;
        nArray6[24] = 1;
        nArray6[25] = 1;
        nArray6[27] = 1;
        nArray6[28] = 1;
        nArray6[31] = 1;
        nArray6[35] = 1;
        baseRing6 = nArray6;
        int[] nArray7 = new int[36];
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[4] = 1;
        nArray7[7] = 1;
        nArray7[8] = 1;
        nArray7[11] = 1;
        nArray7[12] = 1;
        nArray7[17] = 1;
        nArray7[21] = 1;
        nArray7[23] = 1;
        nArray7[27] = 1;
        nArray7[28] = 1;
        nArray7[30] = 1;
        nArray7[31] = 1;
        nArray7[33] = 1;
        baseRing7 = nArray7;
        int[] nArray8 = new int[36];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArray8[7] = 1;
        nArray8[11] = 1;
        nArray8[13] = 1;
        nArray8[15] = 1;
        nArray8[16] = 1;
        nArray8[19] = 1;
        nArray8[20] = 1;
        nArray8[21] = 1;
        nArray8[24] = 1;
        nArray8[26] = 1;
        nArray8[31] = 1;
        nArray8[32] = 1;
        nArray8[34] = 1;
        nArray8[35] = 1;
        baseRing8 = nArray8;
        int[] nArray9 = new int[36];
        nArray9[0] = 1;
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[4] = 1;
        nArray9[6] = 1;
        nArray9[7] = 1;
        nArray9[12] = 1;
        nArray9[15] = 1;
        nArray9[16] = 1;
        nArray9[19] = 1;
        nArray9[21] = 1;
        nArray9[24] = 1;
        nArray9[27] = 1;
        nArray9[28] = 1;
        nArray9[30] = 1;
        nArray9[31] = 1;
        nArray9[32] = 1;
        baseRing9 = nArray9;
        int[] nArray10 = new int[36];
        nArray10[1] = 1;
        nArray10[7] = 1;
        nArray10[9] = 1;
        nArray10[10] = 1;
        nArray10[13] = 1;
        nArray10[14] = 1;
        nArray10[15] = 1;
        nArray10[17] = 1;
        nArray10[21] = 1;
        nArray10[25] = 1;
        nArray10[28] = 1;
        nArray10[29] = 1;
        nArray10[32] = 1;
        nArray10[33] = 1;
        nArray10[34] = 1;
        baseRing10 = nArray10;
        int[] nArray11 = new int[36];
        nArray11[0] = 1;
        nArray11[1] = 1;
        nArray11[4] = 1;
        nArray11[9] = 1;
        nArray11[10] = 1;
        nArray11[14] = 1;
        nArray11[16] = 1;
        nArray11[17] = 1;
        nArray11[21] = 1;
        nArray11[24] = 1;
        nArray11[25] = 1;
        nArray11[30] = 1;
        nArray11[32] = 1;
        baseRing11 = nArray11;
    }

    public NotchRing() {
        this.ring = new int[11][36];
        this.ring[0] = baseRing1;
        this.ring[1] = baseRing2;
        this.ring[2] = baseRing3;
        this.ring[3] = baseRing4;
        this.ring[4] = baseRing5;
        this.ring[5] = baseRing6;
        this.ring[6] = baseRing7;
        this.ring[7] = baseRing8;
        this.ring[8] = baseRing9;
        this.ring[9] = baseRing10;
        this.ring[10] = baseRing11;
    }

    public NotchRing(int num) {
        this();
        if (num < 1 || num > 11) {
            return;
        }
        this.curNRing = new int[36];
        int i = 0;
        while (i < 36) {
            this.curNRing[i] = this.ring[num - 1][i];
            ++i;
        }
        this.name = String.format("%d", num);
        this.id = num;
        this.alphPos = 0;
    }

    public NotchRing(int ringNum, int[] newRing) {
        if (ringNum < 1 || ringNum > 11) {
            System.err.println("Notched Ring #" + ringNum + ": ERROR! " + "wrong ring number! (must be 1 to 11)");
            System.exit(-3);
        }
        if (!this.validateNRing(newRing)) {
            System.err.println("Notched Ring #" + ringNum + ": ERROR! " + "validation failed!");
            System.exit(-3);
        }
        this.curNRing = new int[36];
        this.id = ringNum;
        this.name = String.format("%02d", ringNum);
        int i = 0;
        while (i < 36) {
            this.curNRing[i] = newRing[i];
            ++i;
        }
        this.alphPos = 0;
    }

    boolean validateNRing(int[] ring) {
        if (ring.length != 36) {
            return false;
        }
        int i = 0;
        while (i < 36) {
            if (ring[i] != 0 && ring[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    int getRing() {
        return this.id;
    }

    void setRingPos(byte pos) {
        if (pos < 0 || pos >= 36) {
            this.ringPos = 0;
        }
        this.ringPos = pos;
    }

    byte getRingPos() {
        return this.ringPos;
    }

    void setAlphPos(byte pos) {
        if (pos < 0 || pos >= 36) {
            this.alphPos = 0;
        }
        this.alphPos = pos;
    }

    byte getAlphPos() {
        return this.alphPos;
    }

    public int bump(byte currentPos) {
        int index = (currentPos + this.alphPos + this.ringPos + 10) % 36;
        int i = this.curNRing[index];
        return i;
    }

    public void dumpRing() {
        System.out.print("Notch Ring \"" + this.name + "\"\t");
        int i = 0;
        while (i < 36) {
            System.out.format("%1d", this.curNRing[i]);
            ++i;
        }
        System.out.println();
    }
}

